@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleDestinationVpcConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property roleArn The ARN of a role that has permission to create and attach to elastic network interfaces (ENIs).
 * @property securityGroups The security groups of the VPC destination.
 * @property subnetIds The subnet IDs of the VPC destination.
 * @property vpcId The ID of the VPC.
 */
public data class TopicRuleDestinationVpcConfigurationArgs(
    public val roleArn: Output<String>,
    public val securityGroups: Output<List<String>>? = null,
    public val subnetIds: Output<List<String>>,
    public val vpcId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleDestinationVpcConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleDestinationVpcConfigurationArgs =
        com.pulumi.aws.iot.inputs.TopicRuleDestinationVpcConfigurationArgs.builder()
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcId(vpcId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleDestinationVpcConfigurationArgs].
 */
@PulumiTagMarker
public class TopicRuleDestinationVpcConfigurationArgsBuilder internal constructor() {
    private var roleArn: Output<String>? = null

    private var securityGroups: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The ARN of a role that has permission to create and attach to elastic network interfaces (ENIs).
     */
    @JvmName("gxevmyvvuhngvros")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The security groups of the VPC destination.
     */
    @JvmName("skwxsxxbenuwhish")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("kofdwkgydxyaukbc")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values The security groups of the VPC destination.
     */
    @JvmName("oecbhqojsjntoueu")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value The subnet IDs of the VPC destination.
     */
    @JvmName("swiwebbhndaxlisv")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("opyailxivstdpthi")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values The subnet IDs of the VPC destination.
     */
    @JvmName("wajeonwryjlvcfoa")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("wqsopybdjgprlcgv")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ARN of a role that has permission to create and attach to elastic network interfaces (ENIs).
     */
    @JvmName("kbvgcqshkbifrqph")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The security groups of the VPC destination.
     */
    @JvmName("vdspjpypemfgxoch")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values The security groups of the VPC destination.
     */
    @JvmName("ndgfuayaasefxuwe")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value The subnet IDs of the VPC destination.
     */
    @JvmName("kogknbhpsrvhjmgo")
    public suspend fun subnetIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values The subnet IDs of the VPC destination.
     */
    @JvmName("pnppprmrcowwgsej")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("sdcdajoddwdnbckl")
    public suspend fun vpcId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): TopicRuleDestinationVpcConfigurationArgs =
        TopicRuleDestinationVpcConfigurationArgs(
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
            securityGroups = securityGroups,
            subnetIds = subnetIds ?: throw PulumiNullFieldException("subnetIds"),
            vpcId = vpcId ?: throw PulumiNullFieldException("vpcId"),
        )
}
