@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleDynamodbv2Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property putItem Configuration block with DynamoDB Table to which the message will be written. Nested arguments below.
 * @property roleArn The ARN of the IAM role that grants access to the DynamoDB table.
 */
public data class TopicRuleDynamodbv2Args(
    public val putItem: Output<TopicRuleDynamodbv2PutItemArgs>? = null,
    public val roleArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleDynamodbv2Args> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleDynamodbv2Args =
        com.pulumi.aws.iot.inputs.TopicRuleDynamodbv2Args.builder()
            .putItem(putItem?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleDynamodbv2Args].
 */
@PulumiTagMarker
public class TopicRuleDynamodbv2ArgsBuilder internal constructor() {
    private var putItem: Output<TopicRuleDynamodbv2PutItemArgs>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value Configuration block with DynamoDB Table to which the message will be written. Nested arguments below.
     */
    @JvmName("fladrqdbmdiibfei")
    public suspend fun putItem(`value`: Output<TopicRuleDynamodbv2PutItemArgs>) {
        this.putItem = value
    }

    /**
     * @param value The ARN of the IAM role that grants access to the DynamoDB table.
     */
    @JvmName("xhojhrpxtgnultoq")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Configuration block with DynamoDB Table to which the message will be written. Nested arguments below.
     */
    @JvmName("seqprincrqtsttlb")
    public suspend fun putItem(`value`: TopicRuleDynamodbv2PutItemArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.putItem = mapped
    }

    /**
     * @param argument Configuration block with DynamoDB Table to which the message will be written. Nested arguments below.
     */
    @JvmName("kcrwrkvtotocpjil")
    public suspend fun putItem(argument: suspend TopicRuleDynamodbv2PutItemArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleDynamodbv2PutItemArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.putItem = mapped
    }

    /**
     * @param value The ARN of the IAM role that grants access to the DynamoDB table.
     */
    @JvmName("dcfwrpnrukpdhlpi")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): TopicRuleDynamodbv2Args = TopicRuleDynamodbv2Args(
        putItem = putItem,
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
    )
}
