@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleDynamodbv2PutItemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property tableName The name of the DynamoDB table.
 */
public data class TopicRuleDynamodbv2PutItemArgs(
    public val tableName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleDynamodbv2PutItemArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleDynamodbv2PutItemArgs =
        com.pulumi.aws.iot.inputs.TopicRuleDynamodbv2PutItemArgs.builder()
            .tableName(tableName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleDynamodbv2PutItemArgs].
 */
@PulumiTagMarker
public class TopicRuleDynamodbv2PutItemArgsBuilder internal constructor() {
    private var tableName: Output<String>? = null

    /**
     * @param value The name of the DynamoDB table.
     */
    @JvmName("jpwejaaloavdjnxc")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The name of the DynamoDB table.
     */
    @JvmName("nxbbucmsyaqotenv")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): TopicRuleDynamodbv2PutItemArgs = TopicRuleDynamodbv2PutItemArgs(
        tableName = tableName ?: throw PulumiNullFieldException("tableName"),
    )
}
