@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleErrorActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchAlarm
 * @property cloudwatchLogs
 * @property cloudwatchMetric
 * @property dynamodb
 * @property dynamodbv2
 * @property elasticsearch
 * @property firehose
 * @property http
 * @property iotAnalytics
 * @property iotEvents
 * @property kafka
 * @property kinesis
 * @property lambda
 * @property republish
 * @property s3
 * @property sns
 * @property sqs
 * @property stepFunctions
 * @property timestream
 */
public data class TopicRuleErrorActionArgs(
    public val cloudwatchAlarm: Output<TopicRuleErrorActionCloudwatchAlarmArgs>? = null,
    public val cloudwatchLogs: Output<TopicRuleErrorActionCloudwatchLogsArgs>? = null,
    public val cloudwatchMetric: Output<TopicRuleErrorActionCloudwatchMetricArgs>? = null,
    public val dynamodb: Output<TopicRuleErrorActionDynamodbArgs>? = null,
    public val dynamodbv2: Output<TopicRuleErrorActionDynamodbv2Args>? = null,
    public val elasticsearch: Output<TopicRuleErrorActionElasticsearchArgs>? = null,
    public val firehose: Output<TopicRuleErrorActionFirehoseArgs>? = null,
    public val http: Output<TopicRuleErrorActionHttpArgs>? = null,
    public val iotAnalytics: Output<TopicRuleErrorActionIotAnalyticsArgs>? = null,
    public val iotEvents: Output<TopicRuleErrorActionIotEventsArgs>? = null,
    public val kafka: Output<TopicRuleErrorActionKafkaArgs>? = null,
    public val kinesis: Output<TopicRuleErrorActionKinesisArgs>? = null,
    public val lambda: Output<TopicRuleErrorActionLambdaArgs>? = null,
    public val republish: Output<TopicRuleErrorActionRepublishArgs>? = null,
    public val s3: Output<TopicRuleErrorActionS3Args>? = null,
    public val sns: Output<TopicRuleErrorActionSnsArgs>? = null,
    public val sqs: Output<TopicRuleErrorActionSqsArgs>? = null,
    public val stepFunctions: Output<TopicRuleErrorActionStepFunctionsArgs>? = null,
    public val timestream: Output<TopicRuleErrorActionTimestreamArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleErrorActionArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleErrorActionArgs =
        com.pulumi.aws.iot.inputs.TopicRuleErrorActionArgs.builder()
            .cloudwatchAlarm(cloudwatchAlarm?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cloudwatchLogs(cloudwatchLogs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cloudwatchMetric(cloudwatchMetric?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dynamodb(dynamodb?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dynamodbv2(dynamodbv2?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .elasticsearch(elasticsearch?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .firehose(firehose?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .http(http?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .iotAnalytics(iotAnalytics?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .iotEvents(iotEvents?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kafka(kafka?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kinesis(kinesis?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .lambda(lambda?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .republish(republish?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3(s3?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sns(sns?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sqs(sqs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .stepFunctions(stepFunctions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timestream(timestream?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [TopicRuleErrorActionArgs].
 */
@PulumiTagMarker
public class TopicRuleErrorActionArgsBuilder internal constructor() {
    private var cloudwatchAlarm: Output<TopicRuleErrorActionCloudwatchAlarmArgs>? = null

    private var cloudwatchLogs: Output<TopicRuleErrorActionCloudwatchLogsArgs>? = null

    private var cloudwatchMetric: Output<TopicRuleErrorActionCloudwatchMetricArgs>? = null

    private var dynamodb: Output<TopicRuleErrorActionDynamodbArgs>? = null

    private var dynamodbv2: Output<TopicRuleErrorActionDynamodbv2Args>? = null

    private var elasticsearch: Output<TopicRuleErrorActionElasticsearchArgs>? = null

    private var firehose: Output<TopicRuleErrorActionFirehoseArgs>? = null

    private var http: Output<TopicRuleErrorActionHttpArgs>? = null

    private var iotAnalytics: Output<TopicRuleErrorActionIotAnalyticsArgs>? = null

    private var iotEvents: Output<TopicRuleErrorActionIotEventsArgs>? = null

    private var kafka: Output<TopicRuleErrorActionKafkaArgs>? = null

    private var kinesis: Output<TopicRuleErrorActionKinesisArgs>? = null

    private var lambda: Output<TopicRuleErrorActionLambdaArgs>? = null

    private var republish: Output<TopicRuleErrorActionRepublishArgs>? = null

    private var s3: Output<TopicRuleErrorActionS3Args>? = null

    private var sns: Output<TopicRuleErrorActionSnsArgs>? = null

    private var sqs: Output<TopicRuleErrorActionSqsArgs>? = null

    private var stepFunctions: Output<TopicRuleErrorActionStepFunctionsArgs>? = null

    private var timestream: Output<TopicRuleErrorActionTimestreamArgs>? = null

    /**
     * @param value
     */
    @JvmName("qxbfixxfofdvbual")
    public suspend fun cloudwatchAlarm(`value`: Output<TopicRuleErrorActionCloudwatchAlarmArgs>) {
        this.cloudwatchAlarm = value
    }

    /**
     * @param value
     */
    @JvmName("yhyiljptgwmesuye")
    public suspend fun cloudwatchLogs(`value`: Output<TopicRuleErrorActionCloudwatchLogsArgs>) {
        this.cloudwatchLogs = value
    }

    /**
     * @param value
     */
    @JvmName("xsnacysymhxurxxd")
    public suspend fun cloudwatchMetric(`value`: Output<TopicRuleErrorActionCloudwatchMetricArgs>) {
        this.cloudwatchMetric = value
    }

    /**
     * @param value
     */
    @JvmName("djqveopopqukoklb")
    public suspend fun dynamodb(`value`: Output<TopicRuleErrorActionDynamodbArgs>) {
        this.dynamodb = value
    }

    /**
     * @param value
     */
    @JvmName("fnyhrfrlirfilbfr")
    public suspend fun dynamodbv2(`value`: Output<TopicRuleErrorActionDynamodbv2Args>) {
        this.dynamodbv2 = value
    }

    /**
     * @param value
     */
    @JvmName("efhksklmjlmchfyy")
    public suspend fun elasticsearch(`value`: Output<TopicRuleErrorActionElasticsearchArgs>) {
        this.elasticsearch = value
    }

    /**
     * @param value
     */
    @JvmName("kuhdkdoijstjpprl")
    public suspend fun firehose(`value`: Output<TopicRuleErrorActionFirehoseArgs>) {
        this.firehose = value
    }

    /**
     * @param value
     */
    @JvmName("naaraqtygyvyiwdj")
    public suspend fun http(`value`: Output<TopicRuleErrorActionHttpArgs>) {
        this.http = value
    }

    /**
     * @param value
     */
    @JvmName("ytkqhbsrmkuwuedh")
    public suspend fun iotAnalytics(`value`: Output<TopicRuleErrorActionIotAnalyticsArgs>) {
        this.iotAnalytics = value
    }

    /**
     * @param value
     */
    @JvmName("wqamdwrttpkeeekj")
    public suspend fun iotEvents(`value`: Output<TopicRuleErrorActionIotEventsArgs>) {
        this.iotEvents = value
    }

    /**
     * @param value
     */
    @JvmName("cewdmwhjylpxfdrj")
    public suspend fun kafka(`value`: Output<TopicRuleErrorActionKafkaArgs>) {
        this.kafka = value
    }

    /**
     * @param value
     */
    @JvmName("huufxdrmgcmdlldh")
    public suspend fun kinesis(`value`: Output<TopicRuleErrorActionKinesisArgs>) {
        this.kinesis = value
    }

    /**
     * @param value
     */
    @JvmName("qwyoraxqwcyyfrnf")
    public suspend fun lambda(`value`: Output<TopicRuleErrorActionLambdaArgs>) {
        this.lambda = value
    }

    /**
     * @param value
     */
    @JvmName("xhwwjgfdveefcruw")
    public suspend fun republish(`value`: Output<TopicRuleErrorActionRepublishArgs>) {
        this.republish = value
    }

    /**
     * @param value
     */
    @JvmName("oifckijkinoiuyqf")
    public suspend fun s3(`value`: Output<TopicRuleErrorActionS3Args>) {
        this.s3 = value
    }

    /**
     * @param value
     */
    @JvmName("ldoyaxutvbyynecd")
    public suspend fun sns(`value`: Output<TopicRuleErrorActionSnsArgs>) {
        this.sns = value
    }

    /**
     * @param value
     */
    @JvmName("hsbnlwoyuwfkwran")
    public suspend fun sqs(`value`: Output<TopicRuleErrorActionSqsArgs>) {
        this.sqs = value
    }

    /**
     * @param value
     */
    @JvmName("xqnyqcxdefulbyfj")
    public suspend fun stepFunctions(`value`: Output<TopicRuleErrorActionStepFunctionsArgs>) {
        this.stepFunctions = value
    }

    /**
     * @param value
     */
    @JvmName("scvpyoengxrjkxhl")
    public suspend fun timestream(`value`: Output<TopicRuleErrorActionTimestreamArgs>) {
        this.timestream = value
    }

    /**
     * @param value
     */
    @JvmName("uglobweylpjdwtbn")
    public suspend fun cloudwatchAlarm(`value`: TopicRuleErrorActionCloudwatchAlarmArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchAlarm = mapped
    }

    /**
     * @param argument
     */
    @JvmName("eswvxoypdqbvvqfg")
    public suspend fun cloudwatchAlarm(argument: suspend TopicRuleErrorActionCloudwatchAlarmArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleErrorActionCloudwatchAlarmArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchAlarm = mapped
    }

    /**
     * @param value
     */
    @JvmName("cgmsumvodworfnlk")
    public suspend fun cloudwatchLogs(`value`: TopicRuleErrorActionCloudwatchLogsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLogs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gsuodeytqrgwbkiq")
    public suspend fun cloudwatchLogs(argument: suspend TopicRuleErrorActionCloudwatchLogsArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleErrorActionCloudwatchLogsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLogs = mapped
    }

    /**
     * @param value
     */
    @JvmName("umfemciymycecxkb")
    public suspend fun cloudwatchMetric(`value`: TopicRuleErrorActionCloudwatchMetricArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchMetric = mapped
    }

    /**
     * @param argument
     */
    @JvmName("caqckpqsafbgtsdk")
    public suspend fun cloudwatchMetric(argument: suspend TopicRuleErrorActionCloudwatchMetricArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleErrorActionCloudwatchMetricArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchMetric = mapped
    }

    /**
     * @param value
     */
    @JvmName("ikhwwfjkoqjkjgxa")
    public suspend fun dynamodb(`value`: TopicRuleErrorActionDynamodbArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamodb = mapped
    }

    /**
     * @param argument
     */
    @JvmName("eoixdtqgemukqstx")
    public suspend fun dynamodb(argument: suspend TopicRuleErrorActionDynamodbArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleErrorActionDynamodbArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dynamodb = mapped
    }

    /**
     * @param value
     */
    @JvmName("bbpqrwwvuaxyywvo")
    public suspend fun dynamodbv2(`value`: TopicRuleErrorActionDynamodbv2Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamodbv2 = mapped
    }

    /**
     * @param argument
     */
    @JvmName("iambogjufawlerpj")
    public suspend fun dynamodbv2(argument: suspend TopicRuleErrorActionDynamodbv2ArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleErrorActionDynamodbv2ArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dynamodbv2 = mapped
    }

    /**
     * @param value
     */
    @JvmName("tjyyufuorkllcnyt")
    public suspend fun elasticsearch(`value`: TopicRuleErrorActionElasticsearchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearch = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qxaguflfdeofrmkm")
    public suspend fun elasticsearch(argument: suspend TopicRuleErrorActionElasticsearchArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleErrorActionElasticsearchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.elasticsearch = mapped
    }

    /**
     * @param value
     */
    @JvmName("jfkplwgatncxcacf")
    public suspend fun firehose(`value`: TopicRuleErrorActionFirehoseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firehose = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lwossexlsmjrlqao")
    public suspend fun firehose(argument: suspend TopicRuleErrorActionFirehoseArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleErrorActionFirehoseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.firehose = mapped
    }

    /**
     * @param value
     */
    @JvmName("biumohbhinmxyldr")
    public suspend fun http(`value`: TopicRuleErrorActionHttpArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.http = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mucnjaqdcihcisme")
    public suspend fun http(argument: suspend TopicRuleErrorActionHttpArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleErrorActionHttpArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.http = mapped
    }

    /**
     * @param value
     */
    @JvmName("ydloyvopkwxnqymd")
    public suspend fun iotAnalytics(`value`: TopicRuleErrorActionIotAnalyticsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iotAnalytics = mapped
    }

    /**
     * @param argument
     */
    @JvmName("aejgprvjedruunln")
    public suspend fun iotAnalytics(argument: suspend TopicRuleErrorActionIotAnalyticsArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleErrorActionIotAnalyticsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.iotAnalytics = mapped
    }

    /**
     * @param value
     */
    @JvmName("dcavmfmytkkpixuv")
    public suspend fun iotEvents(`value`: TopicRuleErrorActionIotEventsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iotEvents = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mtnowjkhijxaimun")
    public suspend fun iotEvents(argument: suspend TopicRuleErrorActionIotEventsArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleErrorActionIotEventsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.iotEvents = mapped
    }

    /**
     * @param value
     */
    @JvmName("krxjsjqrqgswhtuj")
    public suspend fun kafka(`value`: TopicRuleErrorActionKafkaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafka = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ohuhavyekpuwchwq")
    public suspend fun kafka(argument: suspend TopicRuleErrorActionKafkaArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleErrorActionKafkaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kafka = mapped
    }

    /**
     * @param value
     */
    @JvmName("qjxgevmjysmmclvl")
    public suspend fun kinesis(`value`: TopicRuleErrorActionKinesisArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesis = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rhdfhqihmauuexnk")
    public suspend fun kinesis(argument: suspend TopicRuleErrorActionKinesisArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleErrorActionKinesisArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kinesis = mapped
    }

    /**
     * @param value
     */
    @JvmName("qpyslppedqcjgnps")
    public suspend fun lambda(`value`: TopicRuleErrorActionLambdaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambda = mapped
    }

    /**
     * @param argument
     */
    @JvmName("abojrbtnwkvhtqdq")
    public suspend fun lambda(argument: suspend TopicRuleErrorActionLambdaArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleErrorActionLambdaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.lambda = mapped
    }

    /**
     * @param value
     */
    @JvmName("cmwkkieqeyjwjwuk")
    public suspend fun republish(`value`: TopicRuleErrorActionRepublishArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.republish = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gvxjodubfmkarjhn")
    public suspend fun republish(argument: suspend TopicRuleErrorActionRepublishArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleErrorActionRepublishArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.republish = mapped
    }

    /**
     * @param value
     */
    @JvmName("tksacqbhsveykqln")
    public suspend fun s3(`value`: TopicRuleErrorActionS3Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3 = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xvnmnwupbwdpidll")
    public suspend fun s3(argument: suspend TopicRuleErrorActionS3ArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleErrorActionS3ArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.s3 = mapped
    }

    /**
     * @param value
     */
    @JvmName("ajhsuwejlonafygk")
    public suspend fun sns(`value`: TopicRuleErrorActionSnsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sns = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lubsygtvwkmphdyj")
    public suspend fun sns(argument: suspend TopicRuleErrorActionSnsArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleErrorActionSnsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sns = mapped
    }

    /**
     * @param value
     */
    @JvmName("tqiysbfgmfdovjrc")
    public suspend fun sqs(`value`: TopicRuleErrorActionSqsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lwupnjsxorfrxvmr")
    public suspend fun sqs(argument: suspend TopicRuleErrorActionSqsArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleErrorActionSqsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sqs = mapped
    }

    /**
     * @param value
     */
    @JvmName("urxeaglljybyaosy")
    public suspend fun stepFunctions(`value`: TopicRuleErrorActionStepFunctionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stepFunctions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lcasckvpbjfnviud")
    public suspend fun stepFunctions(argument: suspend TopicRuleErrorActionStepFunctionsArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleErrorActionStepFunctionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.stepFunctions = mapped
    }

    /**
     * @param value
     */
    @JvmName("xaootduhxuqrerux")
    public suspend fun timestream(`value`: TopicRuleErrorActionTimestreamArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timestream = mapped
    }

    /**
     * @param argument
     */
    @JvmName("kbdhwgnbwedvykbu")
    public suspend fun timestream(argument: suspend TopicRuleErrorActionTimestreamArgsBuilder.() -> Unit) {
        val toBeMapped = TopicRuleErrorActionTimestreamArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timestream = mapped
    }

    internal fun build(): TopicRuleErrorActionArgs = TopicRuleErrorActionArgs(
        cloudwatchAlarm = cloudwatchAlarm,
        cloudwatchLogs = cloudwatchLogs,
        cloudwatchMetric = cloudwatchMetric,
        dynamodb = dynamodb,
        dynamodbv2 = dynamodbv2,
        elasticsearch = elasticsearch,
        firehose = firehose,
        http = http,
        iotAnalytics = iotAnalytics,
        iotEvents = iotEvents,
        kafka = kafka,
        kinesis = kinesis,
        lambda = lambda,
        republish = republish,
        s3 = s3,
        sns = sns,
        sqs = sqs,
        stepFunctions = stepFunctions,
        timestream = timestream,
    )
}
