@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleErrorActionHttpArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property confirmationUrl The HTTPS URL used to verify ownership of `url`.
 * @property httpHeaders Custom HTTP header IoT Core should send. It is possible to define more than one custom header.
 * @property url The HTTPS URL.
 */
public data class TopicRuleErrorActionHttpArgs(
    public val confirmationUrl: Output<String>? = null,
    public val httpHeaders: Output<List<TopicRuleErrorActionHttpHttpHeaderArgs>>? = null,
    public val url: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleErrorActionHttpArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleErrorActionHttpArgs =
        com.pulumi.aws.iot.inputs.TopicRuleErrorActionHttpArgs.builder()
            .confirmationUrl(confirmationUrl?.applyValue({ args0 -> args0 }))
            .httpHeaders(
                httpHeaders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .url(url.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleErrorActionHttpArgs].
 */
@PulumiTagMarker
public class TopicRuleErrorActionHttpArgsBuilder internal constructor() {
    private var confirmationUrl: Output<String>? = null

    private var httpHeaders: Output<List<TopicRuleErrorActionHttpHttpHeaderArgs>>? = null

    private var url: Output<String>? = null

    /**
     * @param value The HTTPS URL used to verify ownership of `url`.
     */
    @JvmName("cengniqoxorcxtsm")
    public suspend fun confirmationUrl(`value`: Output<String>) {
        this.confirmationUrl = value
    }

    /**
     * @param value Custom HTTP header IoT Core should send. It is possible to define more than one custom header.
     */
    @JvmName("tkjwxuoeqttffrky")
    public suspend fun httpHeaders(`value`: Output<List<TopicRuleErrorActionHttpHttpHeaderArgs>>) {
        this.httpHeaders = value
    }

    @JvmName("nyyxulfwtyyesrpb")
    public suspend fun httpHeaders(vararg values: Output<TopicRuleErrorActionHttpHttpHeaderArgs>) {
        this.httpHeaders = Output.all(values.asList())
    }

    /**
     * @param values Custom HTTP header IoT Core should send. It is possible to define more than one custom header.
     */
    @JvmName("cemwkederibaxmym")
    public suspend fun httpHeaders(values: List<Output<TopicRuleErrorActionHttpHttpHeaderArgs>>) {
        this.httpHeaders = Output.all(values)
    }

    /**
     * @param value The HTTPS URL.
     */
    @JvmName("olohhruveqychmqx")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The HTTPS URL used to verify ownership of `url`.
     */
    @JvmName("rsyrjwuuspmdfnep")
    public suspend fun confirmationUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confirmationUrl = mapped
    }

    /**
     * @param value Custom HTTP header IoT Core should send. It is possible to define more than one custom header.
     */
    @JvmName("coitvtqirpndioda")
    public suspend fun httpHeaders(`value`: List<TopicRuleErrorActionHttpHttpHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpHeaders = mapped
    }

    /**
     * @param argument Custom HTTP header IoT Core should send. It is possible to define more than one custom header.
     */
    @JvmName("xavxmkojjwnsjgbx")
    public suspend fun httpHeaders(argument: List<suspend TopicRuleErrorActionHttpHttpHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleErrorActionHttpHttpHeaderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.httpHeaders = mapped
    }

    /**
     * @param argument Custom HTTP header IoT Core should send. It is possible to define more than one custom header.
     */
    @JvmName("yagaktdkbgdtyvdy")
    public suspend fun httpHeaders(vararg argument: suspend TopicRuleErrorActionHttpHttpHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleErrorActionHttpHttpHeaderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.httpHeaders = mapped
    }

    /**
     * @param argument Custom HTTP header IoT Core should send. It is possible to define more than one custom header.
     */
    @JvmName("sfgbgrolhkcufslt")
    public suspend fun httpHeaders(argument: suspend TopicRuleErrorActionHttpHttpHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TopicRuleErrorActionHttpHttpHeaderArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.httpHeaders = mapped
    }

    /**
     * @param values Custom HTTP header IoT Core should send. It is possible to define more than one custom header.
     */
    @JvmName("verutgtvidyiydsr")
    public suspend fun httpHeaders(vararg values: TopicRuleErrorActionHttpHttpHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpHeaders = mapped
    }

    /**
     * @param value The HTTPS URL.
     */
    @JvmName("iegklxaceqxakxqm")
    public suspend fun url(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): TopicRuleErrorActionHttpArgs = TopicRuleErrorActionHttpArgs(
        confirmationUrl = confirmationUrl,
        httpHeaders = httpHeaders,
        url = url ?: throw PulumiNullFieldException("url"),
    )
}
