@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleErrorActionIotAnalyticsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property batchMode The payload that contains a JSON array of records will be sent to IoT Analytics via a batch call.
 * @property channelName Name of AWS IOT Analytics channel.
 * @property roleArn The ARN of the IAM role that grants access.
 */
public data class TopicRuleErrorActionIotAnalyticsArgs(
    public val batchMode: Output<Boolean>? = null,
    public val channelName: Output<String>,
    public val roleArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleErrorActionIotAnalyticsArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleErrorActionIotAnalyticsArgs =
        com.pulumi.aws.iot.inputs.TopicRuleErrorActionIotAnalyticsArgs.builder()
            .batchMode(batchMode?.applyValue({ args0 -> args0 }))
            .channelName(channelName.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleErrorActionIotAnalyticsArgs].
 */
@PulumiTagMarker
public class TopicRuleErrorActionIotAnalyticsArgsBuilder internal constructor() {
    private var batchMode: Output<Boolean>? = null

    private var channelName: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The payload that contains a JSON array of records will be sent to IoT Analytics via a batch call.
     */
    @JvmName("wpafkpltdokhesup")
    public suspend fun batchMode(`value`: Output<Boolean>) {
        this.batchMode = value
    }

    /**
     * @param value Name of AWS IOT Analytics channel.
     */
    @JvmName("wjcmftefqvagvypq")
    public suspend fun channelName(`value`: Output<String>) {
        this.channelName = value
    }

    /**
     * @param value The ARN of the IAM role that grants access.
     */
    @JvmName("qgfnivhddjqruxgq")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The payload that contains a JSON array of records will be sent to IoT Analytics via a batch call.
     */
    @JvmName("qngagbbukncnmgfr")
    public suspend fun batchMode(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchMode = mapped
    }

    /**
     * @param value Name of AWS IOT Analytics channel.
     */
    @JvmName("nbklgkhkaxnoyhtx")
    public suspend fun channelName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelName = mapped
    }

    /**
     * @param value The ARN of the IAM role that grants access.
     */
    @JvmName("pnuibrwpouvvigvc")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): TopicRuleErrorActionIotAnalyticsArgs = TopicRuleErrorActionIotAnalyticsArgs(
        batchMode = batchMode,
        channelName = channelName ?: throw PulumiNullFieldException("channelName"),
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
    )
}
