@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleErrorActionSnsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property messageFormat The message format of the message to publish. Accepted values are "JSON" and "RAW".
 * @property roleArn The ARN of the IAM role that grants access.
 * @property targetArn The ARN of the SNS topic.
 */
public data class TopicRuleErrorActionSnsArgs(
    public val messageFormat: Output<String>? = null,
    public val roleArn: Output<String>,
    public val targetArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleErrorActionSnsArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleErrorActionSnsArgs =
        com.pulumi.aws.iot.inputs.TopicRuleErrorActionSnsArgs.builder()
            .messageFormat(messageFormat?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .targetArn(targetArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleErrorActionSnsArgs].
 */
@PulumiTagMarker
public class TopicRuleErrorActionSnsArgsBuilder internal constructor() {
    private var messageFormat: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var targetArn: Output<String>? = null

    /**
     * @param value The message format of the message to publish. Accepted values are "JSON" and "RAW".
     */
    @JvmName("fcrrwprdulfyqbcr")
    public suspend fun messageFormat(`value`: Output<String>) {
        this.messageFormat = value
    }

    /**
     * @param value The ARN of the IAM role that grants access.
     */
    @JvmName("veutptdeeetuoalv")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The ARN of the SNS topic.
     */
    @JvmName("bcawpabuatftebos")
    public suspend fun targetArn(`value`: Output<String>) {
        this.targetArn = value
    }

    /**
     * @param value The message format of the message to publish. Accepted values are "JSON" and "RAW".
     */
    @JvmName("vylfgjkaprqwtfvo")
    public suspend fun messageFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageFormat = mapped
    }

    /**
     * @param value The ARN of the IAM role that grants access.
     */
    @JvmName("txbrrmjiynytofkl")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The ARN of the SNS topic.
     */
    @JvmName("etovlphmtkxupsti")
    public suspend fun targetArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetArn = mapped
    }

    internal fun build(): TopicRuleErrorActionSnsArgs = TopicRuleErrorActionSnsArgs(
        messageFormat = messageFormat,
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        targetArn = targetArn ?: throw PulumiNullFieldException("targetArn"),
    )
}
