@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleErrorActionStepFunctionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property executionNamePrefix The prefix used to generate, along with a UUID, the unique state machine execution name.
 * @property roleArn The ARN of the IAM role that grants access to start execution of the state machine.
 * @property stateMachineName The name of the Step Functions state machine whose execution will be started.
 */
public data class TopicRuleErrorActionStepFunctionsArgs(
    public val executionNamePrefix: Output<String>? = null,
    public val roleArn: Output<String>,
    public val stateMachineName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleErrorActionStepFunctionsArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleErrorActionStepFunctionsArgs =
        com.pulumi.aws.iot.inputs.TopicRuleErrorActionStepFunctionsArgs.builder()
            .executionNamePrefix(executionNamePrefix?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .stateMachineName(stateMachineName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleErrorActionStepFunctionsArgs].
 */
@PulumiTagMarker
public class TopicRuleErrorActionStepFunctionsArgsBuilder internal constructor() {
    private var executionNamePrefix: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var stateMachineName: Output<String>? = null

    /**
     * @param value The prefix used to generate, along with a UUID, the unique state machine execution name.
     */
    @JvmName("byucfrkaefhxioxh")
    public suspend fun executionNamePrefix(`value`: Output<String>) {
        this.executionNamePrefix = value
    }

    /**
     * @param value The ARN of the IAM role that grants access to start execution of the state machine.
     */
    @JvmName("eluetkqkgghqtrhr")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The name of the Step Functions state machine whose execution will be started.
     */
    @JvmName("ocgtfwcrlfylyoiy")
    public suspend fun stateMachineName(`value`: Output<String>) {
        this.stateMachineName = value
    }

    /**
     * @param value The prefix used to generate, along with a UUID, the unique state machine execution name.
     */
    @JvmName("mouulbofeuhgboie")
    public suspend fun executionNamePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionNamePrefix = mapped
    }

    /**
     * @param value The ARN of the IAM role that grants access to start execution of the state machine.
     */
    @JvmName("yrkhkibwxbnmtprx")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The name of the Step Functions state machine whose execution will be started.
     */
    @JvmName("tovmhiiijlvguayn")
    public suspend fun stateMachineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stateMachineName = mapped
    }

    internal fun build(): TopicRuleErrorActionStepFunctionsArgs =
        TopicRuleErrorActionStepFunctionsArgs(
            executionNamePrefix = executionNamePrefix,
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
            stateMachineName = stateMachineName ?: throw PulumiNullFieldException("stateMachineName"),
        )
}
