@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleErrorActionTimestreamDimensionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The metadata dimension name. This is the name of the column in the Amazon Timestream database table record.
 * @property value The value to write in this column of the database record.
 */
public data class TopicRuleErrorActionTimestreamDimensionArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleErrorActionTimestreamDimensionArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleErrorActionTimestreamDimensionArgs =
        com.pulumi.aws.iot.inputs.TopicRuleErrorActionTimestreamDimensionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleErrorActionTimestreamDimensionArgs].
 */
@PulumiTagMarker
public class TopicRuleErrorActionTimestreamDimensionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The metadata dimension name. This is the name of the column in the Amazon Timestream database table record.
     */
    @JvmName("cmmdoeasxoqawori")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value to write in this column of the database record.
     */
    @JvmName("nsbmrklkwgtyyvmm")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The metadata dimension name. This is the name of the column in the Amazon Timestream database table record.
     */
    @JvmName("jodsitbsiwsbalgt")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value to write in this column of the database record.
     */
    @JvmName("eyuxftqxyypghjqw")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TopicRuleErrorActionTimestreamDimensionArgs =
        TopicRuleErrorActionTimestreamDimensionArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
