@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleErrorActionTimestreamTimestampArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property unit The precision of the timestamp value that results from the expression described in value. Valid values: `SECONDS`, `MILLISECONDS`, `MICROSECONDS`, `NANOSECONDS`.
 * @property value An expression that returns a long epoch time value.
 */
public data class TopicRuleErrorActionTimestreamTimestampArgs(
    public val unit: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleErrorActionTimestreamTimestampArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleErrorActionTimestreamTimestampArgs =
        com.pulumi.aws.iot.inputs.TopicRuleErrorActionTimestreamTimestampArgs.builder()
            .unit(unit.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleErrorActionTimestreamTimestampArgs].
 */
@PulumiTagMarker
public class TopicRuleErrorActionTimestreamTimestampArgsBuilder internal constructor() {
    private var unit: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The precision of the timestamp value that results from the expression described in value. Valid values: `SECONDS`, `MILLISECONDS`, `MICROSECONDS`, `NANOSECONDS`.
     */
    @JvmName("katropglwsoocmwx")
    public suspend fun unit(`value`: Output<String>) {
        this.unit = value
    }

    /**
     * @param value An expression that returns a long epoch time value.
     */
    @JvmName("ywljllhhdlemwuge")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The precision of the timestamp value that results from the expression described in value. Valid values: `SECONDS`, `MILLISECONDS`, `MICROSECONDS`, `NANOSECONDS`.
     */
    @JvmName("tleynhcxcvjivoxy")
    public suspend fun unit(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.unit = mapped
    }

    /**
     * @param value An expression that returns a long epoch time value.
     */
    @JvmName("qbpaealgxvcqkcdp")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TopicRuleErrorActionTimestreamTimestampArgs =
        TopicRuleErrorActionTimestreamTimestampArgs(
            unit = unit ?: throw PulumiNullFieldException("unit"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
