@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleFirehoseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property batchMode The payload that contains a JSON array of records will be sent to Kinesis Firehose via a batch call.
 * @property deliveryStreamName The delivery stream name.
 * @property roleArn The IAM role ARN that grants access to the Amazon Kinesis Firehose stream.
 * @property separator A character separator that is used to separate records written to the Firehose stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
 */
public data class TopicRuleFirehoseArgs(
    public val batchMode: Output<Boolean>? = null,
    public val deliveryStreamName: Output<String>,
    public val roleArn: Output<String>,
    public val separator: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleFirehoseArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleFirehoseArgs =
        com.pulumi.aws.iot.inputs.TopicRuleFirehoseArgs.builder()
            .batchMode(batchMode?.applyValue({ args0 -> args0 }))
            .deliveryStreamName(deliveryStreamName.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .separator(separator?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleFirehoseArgs].
 */
@PulumiTagMarker
public class TopicRuleFirehoseArgsBuilder internal constructor() {
    private var batchMode: Output<Boolean>? = null

    private var deliveryStreamName: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var separator: Output<String>? = null

    /**
     * @param value The payload that contains a JSON array of records will be sent to Kinesis Firehose via a batch call.
     */
    @JvmName("gsfcmdilsgniuxym")
    public suspend fun batchMode(`value`: Output<Boolean>) {
        this.batchMode = value
    }

    /**
     * @param value The delivery stream name.
     */
    @JvmName("gqgtjrixedhfrdkw")
    public suspend fun deliveryStreamName(`value`: Output<String>) {
        this.deliveryStreamName = value
    }

    /**
     * @param value The IAM role ARN that grants access to the Amazon Kinesis Firehose stream.
     */
    @JvmName("nqtdkhntirvlmosr")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value A character separator that is used to separate records written to the Firehose stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
     */
    @JvmName("upbmduqbkorjgdnw")
    public suspend fun separator(`value`: Output<String>) {
        this.separator = value
    }

    /**
     * @param value The payload that contains a JSON array of records will be sent to Kinesis Firehose via a batch call.
     */
    @JvmName("lfttbwbbikooxqmg")
    public suspend fun batchMode(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchMode = mapped
    }

    /**
     * @param value The delivery stream name.
     */
    @JvmName("nkbcauftfcdleyob")
    public suspend fun deliveryStreamName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deliveryStreamName = mapped
    }

    /**
     * @param value The IAM role ARN that grants access to the Amazon Kinesis Firehose stream.
     */
    @JvmName("ucymharceguqtooj")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value A character separator that is used to separate records written to the Firehose stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
     */
    @JvmName("vqsgogrphxtirkga")
    public suspend fun separator(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.separator = mapped
    }

    internal fun build(): TopicRuleFirehoseArgs = TopicRuleFirehoseArgs(
        batchMode = batchMode,
        deliveryStreamName = deliveryStreamName ?: throw PulumiNullFieldException("deliveryStreamName"),
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        separator = separator,
    )
}
