@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleHttpArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property confirmationUrl The HTTPS URL used to verify ownership of `url`.
 * @property httpHeaders Custom HTTP header IoT Core should send. It is possible to define more than one custom header.
 * @property url The HTTPS URL.
 */
public data class TopicRuleHttpArgs(
    public val confirmationUrl: Output<String>? = null,
    public val httpHeaders: Output<List<TopicRuleHttpHttpHeaderArgs>>? = null,
    public val url: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleHttpArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleHttpArgs =
        com.pulumi.aws.iot.inputs.TopicRuleHttpArgs.builder()
            .confirmationUrl(confirmationUrl?.applyValue({ args0 -> args0 }))
            .httpHeaders(
                httpHeaders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .url(url.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleHttpArgs].
 */
@PulumiTagMarker
public class TopicRuleHttpArgsBuilder internal constructor() {
    private var confirmationUrl: Output<String>? = null

    private var httpHeaders: Output<List<TopicRuleHttpHttpHeaderArgs>>? = null

    private var url: Output<String>? = null

    /**
     * @param value The HTTPS URL used to verify ownership of `url`.
     */
    @JvmName("lurwxjaflxiaouso")
    public suspend fun confirmationUrl(`value`: Output<String>) {
        this.confirmationUrl = value
    }

    /**
     * @param value Custom HTTP header IoT Core should send. It is possible to define more than one custom header.
     */
    @JvmName("rhcydqpqjtjutmop")
    public suspend fun httpHeaders(`value`: Output<List<TopicRuleHttpHttpHeaderArgs>>) {
        this.httpHeaders = value
    }

    @JvmName("arnwphvlyqvsjnqm")
    public suspend fun httpHeaders(vararg values: Output<TopicRuleHttpHttpHeaderArgs>) {
        this.httpHeaders = Output.all(values.asList())
    }

    /**
     * @param values Custom HTTP header IoT Core should send. It is possible to define more than one custom header.
     */
    @JvmName("fbkudaiseejamlse")
    public suspend fun httpHeaders(values: List<Output<TopicRuleHttpHttpHeaderArgs>>) {
        this.httpHeaders = Output.all(values)
    }

    /**
     * @param value The HTTPS URL.
     */
    @JvmName("julggjpduaotwsdf")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The HTTPS URL used to verify ownership of `url`.
     */
    @JvmName("seoevvkjpphdkxdi")
    public suspend fun confirmationUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confirmationUrl = mapped
    }

    /**
     * @param value Custom HTTP header IoT Core should send. It is possible to define more than one custom header.
     */
    @JvmName("lgmtobhncqgqvhcl")
    public suspend fun httpHeaders(`value`: List<TopicRuleHttpHttpHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpHeaders = mapped
    }

    /**
     * @param argument Custom HTTP header IoT Core should send. It is possible to define more than one custom header.
     */
    @JvmName("yvxrgpsnuvmxfbtv")
    public suspend fun httpHeaders(argument: List<suspend TopicRuleHttpHttpHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopicRuleHttpHttpHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.httpHeaders = mapped
    }

    /**
     * @param argument Custom HTTP header IoT Core should send. It is possible to define more than one custom header.
     */
    @JvmName("qmipagfrsrvvdbdt")
    public suspend fun httpHeaders(vararg argument: suspend TopicRuleHttpHttpHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TopicRuleHttpHttpHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.httpHeaders = mapped
    }

    /**
     * @param argument Custom HTTP header IoT Core should send. It is possible to define more than one custom header.
     */
    @JvmName("sojdwodsxyihsmid")
    public suspend fun httpHeaders(argument: suspend TopicRuleHttpHttpHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TopicRuleHttpHttpHeaderArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.httpHeaders = mapped
    }

    /**
     * @param values Custom HTTP header IoT Core should send. It is possible to define more than one custom header.
     */
    @JvmName("cyagtwcemmafksqx")
    public suspend fun httpHeaders(vararg values: TopicRuleHttpHttpHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpHeaders = mapped
    }

    /**
     * @param value The HTTPS URL.
     */
    @JvmName("wiliifeptgcylaot")
    public suspend fun url(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): TopicRuleHttpArgs = TopicRuleHttpArgs(
        confirmationUrl = confirmationUrl,
        httpHeaders = httpHeaders,
        url = url ?: throw PulumiNullFieldException("url"),
    )
}
