@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleIotAnalyticArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property batchMode The payload that contains a JSON array of records will be sent to IoT Analytics via a batch call.
 * @property channelName Name of AWS IOT Analytics channel.
 * @property roleArn The ARN of the IAM role that grants access.
 */
public data class TopicRuleIotAnalyticArgs(
    public val batchMode: Output<Boolean>? = null,
    public val channelName: Output<String>,
    public val roleArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleIotAnalyticArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleIotAnalyticArgs =
        com.pulumi.aws.iot.inputs.TopicRuleIotAnalyticArgs.builder()
            .batchMode(batchMode?.applyValue({ args0 -> args0 }))
            .channelName(channelName.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleIotAnalyticArgs].
 */
@PulumiTagMarker
public class TopicRuleIotAnalyticArgsBuilder internal constructor() {
    private var batchMode: Output<Boolean>? = null

    private var channelName: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The payload that contains a JSON array of records will be sent to IoT Analytics via a batch call.
     */
    @JvmName("kkpyoxuvxcjlnigr")
    public suspend fun batchMode(`value`: Output<Boolean>) {
        this.batchMode = value
    }

    /**
     * @param value Name of AWS IOT Analytics channel.
     */
    @JvmName("nfofulpimyedpbem")
    public suspend fun channelName(`value`: Output<String>) {
        this.channelName = value
    }

    /**
     * @param value The ARN of the IAM role that grants access.
     */
    @JvmName("bxndlbmesancsllw")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The payload that contains a JSON array of records will be sent to IoT Analytics via a batch call.
     */
    @JvmName("pfksxpkcbatvvlht")
    public suspend fun batchMode(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchMode = mapped
    }

    /**
     * @param value Name of AWS IOT Analytics channel.
     */
    @JvmName("mbbkbhqjjbxotbsu")
    public suspend fun channelName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelName = mapped
    }

    /**
     * @param value The ARN of the IAM role that grants access.
     */
    @JvmName("nbtitkflhhtdwruw")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): TopicRuleIotAnalyticArgs = TopicRuleIotAnalyticArgs(
        batchMode = batchMode,
        channelName = channelName ?: throw PulumiNullFieldException("channelName"),
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
    )
}
