@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleRepublishArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property qos The Quality of Service (QoS) level to use when republishing messages. Valid values are 0 or 1. The default value is 0.
 * @property roleArn The ARN of the IAM role that grants access.
 * @property topic The name of the MQTT topic the message should be republished to.
 */
public data class TopicRuleRepublishArgs(
    public val qos: Output<Int>? = null,
    public val roleArn: Output<String>,
    public val topic: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleRepublishArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleRepublishArgs =
        com.pulumi.aws.iot.inputs.TopicRuleRepublishArgs.builder()
            .qos(qos?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .topic(topic.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleRepublishArgs].
 */
@PulumiTagMarker
public class TopicRuleRepublishArgsBuilder internal constructor() {
    private var qos: Output<Int>? = null

    private var roleArn: Output<String>? = null

    private var topic: Output<String>? = null

    /**
     * @param value The Quality of Service (QoS) level to use when republishing messages. Valid values are 0 or 1. The default value is 0.
     */
    @JvmName("frvfvnrlunewtkty")
    public suspend fun qos(`value`: Output<Int>) {
        this.qos = value
    }

    /**
     * @param value The ARN of the IAM role that grants access.
     */
    @JvmName("waehvviejnvlcxll")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The name of the MQTT topic the message should be republished to.
     */
    @JvmName("hgotxtisntsoeonx")
    public suspend fun topic(`value`: Output<String>) {
        this.topic = value
    }

    /**
     * @param value The Quality of Service (QoS) level to use when republishing messages. Valid values are 0 or 1. The default value is 0.
     */
    @JvmName("mjawspniuuythxoi")
    public suspend fun qos(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qos = mapped
    }

    /**
     * @param value The ARN of the IAM role that grants access.
     */
    @JvmName("hiviejrakpidmuuk")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The name of the MQTT topic the message should be republished to.
     */
    @JvmName("leoabwqrpmgcgvhl")
    public suspend fun topic(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topic = mapped
    }

    internal fun build(): TopicRuleRepublishArgs = TopicRuleRepublishArgs(
        qos = qos,
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        topic = topic ?: throw PulumiNullFieldException("topic"),
    )
}
