@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleStepFunctionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property executionNamePrefix The prefix used to generate, along with a UUID, the unique state machine execution name.
 * @property roleArn The ARN of the IAM role that grants access to start execution of the state machine.
 * @property stateMachineName The name of the Step Functions state machine whose execution will be started.
 */
public data class TopicRuleStepFunctionArgs(
    public val executionNamePrefix: Output<String>? = null,
    public val roleArn: Output<String>,
    public val stateMachineName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleStepFunctionArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleStepFunctionArgs =
        com.pulumi.aws.iot.inputs.TopicRuleStepFunctionArgs.builder()
            .executionNamePrefix(executionNamePrefix?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .stateMachineName(stateMachineName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleStepFunctionArgs].
 */
@PulumiTagMarker
public class TopicRuleStepFunctionArgsBuilder internal constructor() {
    private var executionNamePrefix: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var stateMachineName: Output<String>? = null

    /**
     * @param value The prefix used to generate, along with a UUID, the unique state machine execution name.
     */
    @JvmName("aygtusgecwxachqm")
    public suspend fun executionNamePrefix(`value`: Output<String>) {
        this.executionNamePrefix = value
    }

    /**
     * @param value The ARN of the IAM role that grants access to start execution of the state machine.
     */
    @JvmName("uudehsclxcypdxtc")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The name of the Step Functions state machine whose execution will be started.
     */
    @JvmName("bktfdhpqocumaqdg")
    public suspend fun stateMachineName(`value`: Output<String>) {
        this.stateMachineName = value
    }

    /**
     * @param value The prefix used to generate, along with a UUID, the unique state machine execution name.
     */
    @JvmName("twrarhevafffaheh")
    public suspend fun executionNamePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionNamePrefix = mapped
    }

    /**
     * @param value The ARN of the IAM role that grants access to start execution of the state machine.
     */
    @JvmName("mdfcjvvciqtaglus")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The name of the Step Functions state machine whose execution will be started.
     */
    @JvmName("uqardmsuaeejcdsd")
    public suspend fun stateMachineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stateMachineName = mapped
    }

    internal fun build(): TopicRuleStepFunctionArgs = TopicRuleStepFunctionArgs(
        executionNamePrefix = executionNamePrefix,
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        stateMachineName = stateMachineName ?: throw PulumiNullFieldException("stateMachineName"),
    )
}
