@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.inputs

import com.pulumi.aws.iot.inputs.TopicRuleTimestreamDimensionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The metadata dimension name. This is the name of the column in the Amazon Timestream database table record.
 * @property value The value to write in this column of the database record.
 */
public data class TopicRuleTimestreamDimensionArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.iot.inputs.TopicRuleTimestreamDimensionArgs> {
    override fun toJava(): com.pulumi.aws.iot.inputs.TopicRuleTimestreamDimensionArgs =
        com.pulumi.aws.iot.inputs.TopicRuleTimestreamDimensionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicRuleTimestreamDimensionArgs].
 */
@PulumiTagMarker
public class TopicRuleTimestreamDimensionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The metadata dimension name. This is the name of the column in the Amazon Timestream database table record.
     */
    @JvmName("kksbgkymrriopqtf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value to write in this column of the database record.
     */
    @JvmName("rlligflppsbjhewv")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The metadata dimension name. This is the name of the column in the Amazon Timestream database table record.
     */
    @JvmName("uqahskveligxiitp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value to write in this column of the database record.
     */
    @JvmName("akfekrreiohnamue")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TopicRuleTimestreamDimensionArgs = TopicRuleTimestreamDimensionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
