@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property roleArn The ARN of the role.
 * @property templateBody The template body.
 * @property templateName The name of the provisioning template.
 */
public data class CaCertificateRegistrationConfig(
    public val roleArn: String? = null,
    public val templateBody: String? = null,
    public val templateName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.CaCertificateRegistrationConfig): CaCertificateRegistrationConfig = CaCertificateRegistrationConfig(
            roleArn = javaType.roleArn().map({ args0 -> args0 }).orElse(null),
            templateBody = javaType.templateBody().map({ args0 -> args0 }).orElse(null),
            templateName = javaType.templateName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
