@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getRegistrationCode.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property registrationCode The CA certificate registration code.
 */
public data class GetRegistrationCodeResult(
    public val id: String,
    public val registrationCode: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.GetRegistrationCodeResult): GetRegistrationCodeResult = GetRegistrationCodeResult(
            id = javaType.id(),
            registrationCode = javaType.registrationCode(),
        )
    }
}
