@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property customFields Contains custom field names and their data type. See below.
 * @property deviceDefenderIndexingMode Device Defender indexing mode. Valid values: `VIOLATIONS`, `OFF`. Default: `OFF`.
 * @property filter Required if `named_shadow_indexing_mode` is `ON`. Enables to add named shadows filtered by `filter` to fleet indexing configuration.
 * @property managedFields Contains fields that are indexed and whose types are already known by the Fleet Indexing service. See below.
 * @property namedShadowIndexingMode [Named shadow](https://docs.aws.amazon.com/iot/latest/developerguide/iot-device-shadows.html) indexing mode. Valid values: `ON`, `OFF`. Default: `OFF`.
 * @property thingConnectivityIndexingMode Thing connectivity indexing mode. Valid values: `STATUS`, `OFF`. Default: `OFF`.
 * @property thingIndexingMode Thing indexing mode. Valid values: `REGISTRY`, `REGISTRY_AND_SHADOW`, `OFF`.
 */
public data class IndexingConfigurationThingIndexingConfiguration(
    public val customFields: List<IndexingConfigurationThingIndexingConfigurationCustomField>? = null,
    public val deviceDefenderIndexingMode: String? = null,
    public val filter: IndexingConfigurationThingIndexingConfigurationFilter? = null,
    public val managedFields: List<IndexingConfigurationThingIndexingConfigurationManagedField>? =
        null,
    public val namedShadowIndexingMode: String? = null,
    public val thingConnectivityIndexingMode: String? = null,
    public val thingIndexingMode: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.IndexingConfigurationThingIndexingConfiguration): IndexingConfigurationThingIndexingConfiguration =
            IndexingConfigurationThingIndexingConfiguration(
                customFields = javaType.customFields().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.iot.kotlin.outputs.IndexingConfigurationThingIndexingConfigurationCustomField.Companion.toKotlin(args0)
                    })
                }),
                deviceDefenderIndexingMode = javaType.deviceDefenderIndexingMode().map({ args0 ->
                    args0
                }).orElse(null),
                filter = javaType.filter().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.iot.kotlin.outputs.IndexingConfigurationThingIndexingConfigurationFilter.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                managedFields = javaType.managedFields().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.iot.kotlin.outputs.IndexingConfigurationThingIndexingConfigurationManagedField.Companion.toKotlin(args0)
                    })
                }),
                namedShadowIndexingMode = javaType.namedShadowIndexingMode().map({ args0 -> args0 }).orElse(null),
                thingConnectivityIndexingMode = javaType.thingConnectivityIndexingMode().map({ args0 ->
                    args0
                }).orElse(null),
                thingIndexingMode = javaType.thingIndexingMode(),
            )
    }
}
