@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property payloadVersion The version of the payload that was sent to the target function. The only valid (and the default) payload version is `"2020-04-01"`.
 * @property targetArn The ARN of the target function.
 */
public data class ProvisioningTemplatePreProvisioningHook(
    public val payloadVersion: String? = null,
    public val targetArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.ProvisioningTemplatePreProvisioningHook): ProvisioningTemplatePreProvisioningHook = ProvisioningTemplatePreProvisioningHook(
            payloadVersion = javaType.payloadVersion().map({ args0 -> args0 }).orElse(null),
            targetArn = javaType.targetArn(),
        )
    }
}
