@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property description The description of the thing type.
 * @property searchableAttributes A list of searchable thing attribute names.
 */
public data class ThingTypeProperties(
    public val description: String? = null,
    public val searchableAttributes: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.ThingTypeProperties): ThingTypeProperties = ThingTypeProperties(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            searchableAttributes = javaType.searchableAttributes().map({ args0 -> args0 }),
        )
    }
}
