@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property putItem Configuration block with DynamoDB Table to which the message will be written. Nested arguments below.
 * @property roleArn The ARN of the IAM role that grants access to the DynamoDB table.
 */
public data class TopicRuleDynamodbv2(
    public val putItem: TopicRuleDynamodbv2PutItem? = null,
    public val roleArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.TopicRuleDynamodbv2): TopicRuleDynamodbv2 = TopicRuleDynamodbv2(
            putItem = javaType.putItem().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.iot.kotlin.outputs.TopicRuleDynamodbv2PutItem.Companion.toKotlin(args0)
                })
            }).orElse(null),
            roleArn = javaType.roleArn(),
        )
    }
}
