@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endpoint The endpoint of your Elasticsearch domain.
 * @property id The unique identifier for the document you are storing.
 * @property index The Elasticsearch index where you want to store your data.
 * @property roleArn The IAM role ARN that has access to Elasticsearch.
 * @property type The type of document you are storing.
 */
public data class TopicRuleElasticsearch(
    public val endpoint: String,
    public val id: String,
    public val index: String,
    public val roleArn: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.TopicRuleElasticsearch): TopicRuleElasticsearch = TopicRuleElasticsearch(
            endpoint = javaType.endpoint(),
            id = javaType.id(),
            index = javaType.index(),
            roleArn = javaType.roleArn(),
            type = javaType.type(),
        )
    }
}
