@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property alarmName The CloudWatch alarm name.
 * @property roleArn The IAM role ARN that allows access to the CloudWatch alarm.
 * @property stateReason The reason for the alarm change.
 * @property stateValue The value of the alarm state. Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.
 */
public data class TopicRuleErrorActionCloudwatchAlarm(
    public val alarmName: String,
    public val roleArn: String,
    public val stateReason: String,
    public val stateValue: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.TopicRuleErrorActionCloudwatchAlarm): TopicRuleErrorActionCloudwatchAlarm = TopicRuleErrorActionCloudwatchAlarm(
            alarmName = javaType.alarmName(),
            roleArn = javaType.roleArn(),
            stateReason = javaType.stateReason(),
            stateValue = javaType.stateValue(),
        )
    }
}
