@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property batchMode The payload that contains a JSON array of records will be sent to CloudWatch via a batch call.
 * @property logGroupName The CloudWatch log group name.
 * @property roleArn The IAM role ARN that allows access to the CloudWatch alarm.
 */
public data class TopicRuleErrorActionCloudwatchLogs(
    public val batchMode: Boolean? = null,
    public val logGroupName: String,
    public val roleArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.TopicRuleErrorActionCloudwatchLogs): TopicRuleErrorActionCloudwatchLogs = TopicRuleErrorActionCloudwatchLogs(
            batchMode = javaType.batchMode().map({ args0 -> args0 }).orElse(null),
            logGroupName = javaType.logGroupName(),
            roleArn = javaType.roleArn(),
        )
    }
}
