@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property hashKeyField The hash key name.
 * @property hashKeyType The hash key type. Valid values are "STRING" or "NUMBER".
 * @property hashKeyValue The hash key value.
 * @property operation The operation. Valid values are "INSERT", "UPDATE", or "DELETE".
 * @property payloadField The action payload.
 * @property rangeKeyField The range key name.
 * @property rangeKeyType The range key type. Valid values are "STRING" or "NUMBER".
 * @property rangeKeyValue The range key value.
 * @property roleArn The ARN of the IAM role that grants access to the DynamoDB table.
 * @property tableName The name of the DynamoDB table.
 */
public data class TopicRuleErrorActionDynamodb(
    public val hashKeyField: String,
    public val hashKeyType: String? = null,
    public val hashKeyValue: String,
    public val operation: String? = null,
    public val payloadField: String? = null,
    public val rangeKeyField: String? = null,
    public val rangeKeyType: String? = null,
    public val rangeKeyValue: String? = null,
    public val roleArn: String,
    public val tableName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.TopicRuleErrorActionDynamodb): TopicRuleErrorActionDynamodb = TopicRuleErrorActionDynamodb(
            hashKeyField = javaType.hashKeyField(),
            hashKeyType = javaType.hashKeyType().map({ args0 -> args0 }).orElse(null),
            hashKeyValue = javaType.hashKeyValue(),
            operation = javaType.operation().map({ args0 -> args0 }).orElse(null),
            payloadField = javaType.payloadField().map({ args0 -> args0 }).orElse(null),
            rangeKeyField = javaType.rangeKeyField().map({ args0 -> args0 }).orElse(null),
            rangeKeyType = javaType.rangeKeyType().map({ args0 -> args0 }).orElse(null),
            rangeKeyValue = javaType.rangeKeyValue().map({ args0 -> args0 }).orElse(null),
            roleArn = javaType.roleArn(),
            tableName = javaType.tableName(),
        )
    }
}
