@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property batchMode The payload that contains a JSON array of records will be sent to Kinesis Firehose via a batch call.
 * @property deliveryStreamName The delivery stream name.
 * @property roleArn The IAM role ARN that grants access to the Amazon Kinesis Firehose stream.
 * @property separator A character separator that is used to separate records written to the Firehose stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
 */
public data class TopicRuleErrorActionFirehose(
    public val batchMode: Boolean? = null,
    public val deliveryStreamName: String,
    public val roleArn: String,
    public val separator: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.TopicRuleErrorActionFirehose): TopicRuleErrorActionFirehose = TopicRuleErrorActionFirehose(
            batchMode = javaType.batchMode().map({ args0 -> args0 }).orElse(null),
            deliveryStreamName = javaType.deliveryStreamName(),
            roleArn = javaType.roleArn(),
            separator = javaType.separator().map({ args0 -> args0 }).orElse(null),
        )
    }
}
