@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property confirmationUrl The HTTPS URL used to verify ownership of `url`.
 * @property httpHeaders Custom HTTP header IoT Core should send. It is possible to define more than one custom header.
 * @property url The HTTPS URL.
 */
public data class TopicRuleErrorActionHttp(
    public val confirmationUrl: String? = null,
    public val httpHeaders: List<TopicRuleErrorActionHttpHttpHeader>? = null,
    public val url: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.TopicRuleErrorActionHttp): TopicRuleErrorActionHttp = TopicRuleErrorActionHttp(
            confirmationUrl = javaType.confirmationUrl().map({ args0 -> args0 }).orElse(null),
            httpHeaders = javaType.httpHeaders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.iot.kotlin.outputs.TopicRuleErrorActionHttpHttpHeader.Companion.toKotlin(args0)
                })
            }),
            url = javaType.url(),
        )
    }
}
