@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property batchMode The payload that contains a JSON array of records will be sent to IoT Events via a batch call.
 * @property inputName The name of the AWS IoT Events input.
 * @property messageId Use this to ensure that only one input (message) with a given messageId is processed by an AWS IoT Events detector.
 * @property roleArn The ARN of the IAM role that grants access.
 */
public data class TopicRuleErrorActionIotEvents(
    public val batchMode: Boolean? = null,
    public val inputName: String,
    public val messageId: String? = null,
    public val roleArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.TopicRuleErrorActionIotEvents): TopicRuleErrorActionIotEvents = TopicRuleErrorActionIotEvents(
            batchMode = javaType.batchMode().map({ args0 -> args0 }).orElse(null),
            inputName = javaType.inputName(),
            messageId = javaType.messageId().map({ args0 -> args0 }).orElse(null),
            roleArn = javaType.roleArn(),
        )
    }
}
