@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property clientProperties Properties of the Apache Kafka producer client. For more info, see the [AWS documentation](https://docs.aws.amazon.com/iot/latest/developerguide/apache-kafka-rule-action.html).
 * @property destinationArn The ARN of Kafka action's VPC `aws.iot.TopicRuleDestination`.
 * @property headers The list of Kafka headers that you specify. Nested arguments below.
 * @property key The Kafka message key.
 * @property partition The Kafka message partition.
 * @property topic The Kafka topic for messages to be sent to the Kafka broker.
 */
public data class TopicRuleErrorActionKafka(
    public val clientProperties: Map<String, String>,
    public val destinationArn: String,
    public val headers: List<TopicRuleErrorActionKafkaHeader>? = null,
    public val key: String? = null,
    public val partition: String? = null,
    public val topic: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.TopicRuleErrorActionKafka): TopicRuleErrorActionKafka = TopicRuleErrorActionKafka(
            clientProperties = javaType.clientProperties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            destinationArn = javaType.destinationArn(),
            headers = javaType.headers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.iot.kotlin.outputs.TopicRuleErrorActionKafkaHeader.Companion.toKotlin(args0)
                })
            }),
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
            partition = javaType.partition().map({ args0 -> args0 }).orElse(null),
            topic = javaType.topic(),
        )
    }
}
