@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property partitionKey The partition key.
 * @property roleArn The ARN of the IAM role that grants access to the Amazon Kinesis stream.
 * @property streamName The name of the Amazon Kinesis stream.
 */
public data class TopicRuleErrorActionKinesis(
    public val partitionKey: String? = null,
    public val roleArn: String,
    public val streamName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.TopicRuleErrorActionKinesis): TopicRuleErrorActionKinesis = TopicRuleErrorActionKinesis(
            partitionKey = javaType.partitionKey().map({ args0 -> args0 }).orElse(null),
            roleArn = javaType.roleArn(),
            streamName = javaType.streamName(),
        )
    }
}
