@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property qos The Quality of Service (QoS) level to use when republishing messages. Valid values are 0 or 1. The default value is 0.
 * @property roleArn The ARN of the IAM role that grants access.
 * @property topic The name of the MQTT topic the message should be republished to.
 */
public data class TopicRuleErrorActionRepublish(
    public val qos: Int? = null,
    public val roleArn: String,
    public val topic: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.TopicRuleErrorActionRepublish): TopicRuleErrorActionRepublish = TopicRuleErrorActionRepublish(
            qos = javaType.qos().map({ args0 -> args0 }).orElse(null),
            roleArn = javaType.roleArn(),
            topic = javaType.topic(),
        )
    }
}
