@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property queueUrl The URL of the Amazon SQS queue.
 * @property roleArn The ARN of the IAM role that grants access.
 * @property useBase64 Specifies whether to use Base64 encoding.
 */
public data class TopicRuleErrorActionSqs(
    public val queueUrl: String,
    public val roleArn: String,
    public val useBase64: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.TopicRuleErrorActionSqs): TopicRuleErrorActionSqs = TopicRuleErrorActionSqs(
            queueUrl = javaType.queueUrl(),
            roleArn = javaType.roleArn(),
            useBase64 = javaType.useBase64(),
        )
    }
}
