@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName The Amazon S3 bucket name.
 * @property cannedAcl The Amazon S3 canned ACL that controls access to the object identified by the object key. [Valid values](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl).
 * @property key The object key.
 * @property roleArn The ARN of the IAM role that grants access.
 */
public data class TopicRuleS3(
    public val bucketName: String,
    public val cannedAcl: String? = null,
    public val key: String,
    public val roleArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.TopicRuleS3): TopicRuleS3 =
            TopicRuleS3(
                bucketName = javaType.bucketName(),
                cannedAcl = javaType.cannedAcl().map({ args0 -> args0 }).orElse(null),
                key = javaType.key(),
                roleArn = javaType.roleArn(),
            )
    }
}
