@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iot.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property messageFormat The message format of the message to publish. Accepted values are "JSON" and "RAW".
 * @property roleArn The ARN of the IAM role that grants access.
 * @property targetArn The ARN of the SNS topic.
 */
public data class TopicRuleSns(
    public val messageFormat: String? = null,
    public val roleArn: String,
    public val targetArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iot.outputs.TopicRuleSns): TopicRuleSns =
            TopicRuleSns(
                messageFormat = javaType.messageFormat().map({ args0 -> args0 }).orElse(null),
                roleArn = javaType.roleArn(),
                targetArn = javaType.targetArn(),
            )
    }
}
