@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Channel].
 */
@PulumiTagMarker
public class ChannelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ChannelArgs = ChannelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ChannelArgsBuilder.() -> Unit) {
        val builder = ChannelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Channel {
        val builtJavaResource = com.pulumi.aws.ivs.Channel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Channel(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS IVS (Interactive Video) Channel.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ivs.Channel("example", {name: "channel-1"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ivs.Channel("example", name="channel-1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ivs.Channel("example", new()
 *     {
 *         Name = "channel-1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ivs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ivs.NewChannel(ctx, "example", &ivs.ChannelArgs{
 * 			Name: pulumi.String("channel-1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ivs.Channel;
 * import com.pulumi.aws.ivs.ChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Channel("example", ChannelArgs.builder()
 *             .name("channel-1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ivs:Channel
 *     properties:
 *       name: channel-1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IVS (Interactive Video) Channel using the ARN. For example:
 * ```sh
 * $ pulumi import aws:ivs/channel:Channel example arn:aws:ivs:us-west-2:326937407773:channel/0Y1lcs4U7jk5
 * ```
 */
public class Channel internal constructor(
    override val javaResource: com.pulumi.aws.ivs.Channel,
) : KotlinCustomResource(javaResource, ChannelMapper) {
    /**
     * ARN of the Channel.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * If `true`, channel is private (enabled for playback authorization).
     */
    public val authorized: Output<Boolean>
        get() = javaResource.authorized().applyValue({ args0 -> args0 })

    /**
     * Channel ingest endpoint, part of the definition of an ingest server, used when setting up streaming software.
     */
    public val ingestEndpoint: Output<String>
        get() = javaResource.ingestEndpoint().applyValue({ args0 -> args0 })

    /**
     * Channel latency mode. Valid values: `NORMAL`, `LOW`.
     */
    public val latencyMode: Output<String>
        get() = javaResource.latencyMode().applyValue({ args0 -> args0 })

    /**
     * Channel name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Channel playback URL.
     */
    public val playbackUrl: Output<String>
        get() = javaResource.playbackUrl().applyValue({ args0 -> args0 })

    /**
     * Recording configuration ARN.
     */
    public val recordingConfigurationArn: Output<String>
        get() = javaResource.recordingConfigurationArn().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Channel type, which determines the allowable resolution and bitrate. Valid values: `STANDARD`, `BASIC`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ChannelMapper : ResourceMapper<Channel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ivs.Channel::class == javaResource::class

    override fun map(javaResource: Resource): Channel = Channel(
        javaResource as
            com.pulumi.aws.ivs.Channel,
    )
}

/**
 * @see [Channel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Channel].
 */
public suspend fun channel(name: String, block: suspend ChannelResourceBuilder.() -> Unit): Channel {
    val builder = ChannelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Channel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun channel(name: String): Channel {
    val builder = ChannelResourceBuilder()
    builder.name(name)
    return builder.build()
}
