@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivs.kotlin

import com.pulumi.aws.ivs.ChannelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS IVS (Interactive Video) Channel.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ivs.Channel("example", {name: "channel-1"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ivs.Channel("example", name="channel-1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ivs.Channel("example", new()
 *     {
 *         Name = "channel-1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ivs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ivs.NewChannel(ctx, "example", &ivs.ChannelArgs{
 * 			Name: pulumi.String("channel-1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ivs.Channel;
 * import com.pulumi.aws.ivs.ChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Channel("example", ChannelArgs.builder()
 *             .name("channel-1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ivs:Channel
 *     properties:
 *       name: channel-1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IVS (Interactive Video) Channel using the ARN. For example:
 * ```sh
 * $ pulumi import aws:ivs/channel:Channel example arn:aws:ivs:us-west-2:326937407773:channel/0Y1lcs4U7jk5
 * ```
 * @property authorized If `true`, channel is private (enabled for playback authorization).
 * @property latencyMode Channel latency mode. Valid values: `NORMAL`, `LOW`.
 * @property name Channel name.
 * @property recordingConfigurationArn Recording configuration ARN.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type Channel type, which determines the allowable resolution and bitrate. Valid values: `STANDARD`, `BASIC`.
 */
public data class ChannelArgs(
    public val authorized: Output<Boolean>? = null,
    public val latencyMode: Output<String>? = null,
    public val name: Output<String>? = null,
    public val recordingConfigurationArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ivs.ChannelArgs> {
    override fun toJava(): com.pulumi.aws.ivs.ChannelArgs = com.pulumi.aws.ivs.ChannelArgs.builder()
        .authorized(authorized?.applyValue({ args0 -> args0 }))
        .latencyMode(latencyMode?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .recordingConfigurationArn(recordingConfigurationArn?.applyValue({ args0 -> args0 }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelArgs].
 */
@PulumiTagMarker
public class ChannelArgsBuilder internal constructor() {
    private var authorized: Output<Boolean>? = null

    private var latencyMode: Output<String>? = null

    private var name: Output<String>? = null

    private var recordingConfigurationArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value If `true`, channel is private (enabled for playback authorization).
     */
    @JvmName("epmrflulbxsjsrpe")
    public suspend fun authorized(`value`: Output<Boolean>) {
        this.authorized = value
    }

    /**
     * @param value Channel latency mode. Valid values: `NORMAL`, `LOW`.
     */
    @JvmName("vjayqvtlqchsvixu")
    public suspend fun latencyMode(`value`: Output<String>) {
        this.latencyMode = value
    }

    /**
     * @param value Channel name.
     */
    @JvmName("cjhohxoroccrupcv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Recording configuration ARN.
     */
    @JvmName("pwebytdspoxvgwrg")
    public suspend fun recordingConfigurationArn(`value`: Output<String>) {
        this.recordingConfigurationArn = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fgaskpoyrxqbqxhj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Channel type, which determines the allowable resolution and bitrate. Valid values: `STANDARD`, `BASIC`.
     */
    @JvmName("fglyjgooaepmndqm")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value If `true`, channel is private (enabled for playback authorization).
     */
    @JvmName("nfkvhfdkpgfggvmg")
    public suspend fun authorized(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorized = mapped
    }

    /**
     * @param value Channel latency mode. Valid values: `NORMAL`, `LOW`.
     */
    @JvmName("meiyysbfqeeuxogm")
    public suspend fun latencyMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.latencyMode = mapped
    }

    /**
     * @param value Channel name.
     */
    @JvmName("wvnbrlcarrkatyic")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Recording configuration ARN.
     */
    @JvmName("qjkvddfnarpfsukp")
    public suspend fun recordingConfigurationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordingConfigurationArn = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fjgwklbqrvngovxh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fpujuxgmdeimoodh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Channel type, which determines the allowable resolution and bitrate. Valid values: `STANDARD`, `BASIC`.
     */
    @JvmName("drltdscpkrysiskw")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ChannelArgs = ChannelArgs(
        authorized = authorized,
        latencyMode = latencyMode,
        name = name,
        recordingConfigurationArn = recordingConfigurationArn,
        tags = tags,
        type = type,
    )
}
