@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [PlaybackKeyPair].
 */
@PulumiTagMarker
public class PlaybackKeyPairResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PlaybackKeyPairArgs = PlaybackKeyPairArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PlaybackKeyPairArgsBuilder.() -> Unit) {
        val builder = PlaybackKeyPairArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PlaybackKeyPair {
        val builtJavaResource = com.pulumi.aws.ivs.PlaybackKeyPair(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PlaybackKeyPair(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS IVS (Interactive Video) Playback Key Pair.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.ivs.PlaybackKeyPair("example", {publicKey: std.file({
 *     input: "./public-key.pem",
 * }).then(invoke => invoke.result)});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.ivs.PlaybackKeyPair("example", public_key=std.file(input="./public-key.pem").result)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ivs.PlaybackKeyPair("example", new()
 *     {
 *         PublicKey = Std.File.Invoke(new()
 *         {
 *             Input = "./public-key.pem",
 *         }).Apply(invoke => invoke.Result),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ivs"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "./public-key.pem",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ivs.NewPlaybackKeyPair(ctx, "example", &ivs.PlaybackKeyPairArgs{
 * 			PublicKey: pulumi.String(invokeFile.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ivs.PlaybackKeyPair;
 * import com.pulumi.aws.ivs.PlaybackKeyPairArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PlaybackKeyPair("example", PlaybackKeyPairArgs.builder()
 *             .publicKey(StdFunctions.file(FileArgs.builder()
 *                 .input("./public-key.pem")
 *                 .build()).result())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ivs:PlaybackKeyPair
 *     properties:
 *       publicKey:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: ./public-key.pem
 *           Return: result
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IVS (Interactive Video) Playback Key Pair using the ARN. For example:
 * ```sh
 * $ pulumi import aws:ivs/playbackKeyPair:PlaybackKeyPair example arn:aws:ivs:us-west-2:326937407773:playback-key/KDJRJNQhiQzA
 * ```
 */
public class PlaybackKeyPair internal constructor(
    override val javaResource: com.pulumi.aws.ivs.PlaybackKeyPair,
) : KotlinCustomResource(javaResource, PlaybackKeyPairMapper) {
    /**
     * ARN of the Playback Key Pair.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Key-pair identifier.
     */
    public val fingerprint: Output<String>
        get() = javaResource.fingerprint().applyValue({ args0 -> args0 })

    /**
     * Playback Key Pair name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Public portion of a customer-generated key pair. Must be an ECDSA public key in PEM format.
     * The following arguments are optional:
     */
    public val publicKey: Output<String>
        get() = javaResource.publicKey().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object PlaybackKeyPairMapper : ResourceMapper<PlaybackKeyPair> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ivs.PlaybackKeyPair::class == javaResource::class

    override fun map(javaResource: Resource): PlaybackKeyPair = PlaybackKeyPair(
        javaResource as
            com.pulumi.aws.ivs.PlaybackKeyPair,
    )
}

/**
 * @see [PlaybackKeyPair].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PlaybackKeyPair].
 */
public suspend fun playbackKeyPair(
    name: String,
    block: suspend PlaybackKeyPairResourceBuilder.() -> Unit,
): PlaybackKeyPair {
    val builder = PlaybackKeyPairResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PlaybackKeyPair].
 * @param name The _unique_ name of the resulting resource.
 */
public fun playbackKeyPair(name: String): PlaybackKeyPair {
    val builder = PlaybackKeyPairResourceBuilder()
    builder.name(name)
    return builder.build()
}
