@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivs.kotlin

import com.pulumi.aws.ivs.PlaybackKeyPairArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS IVS (Interactive Video) Playback Key Pair.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.ivs.PlaybackKeyPair("example", {publicKey: std.file({
 *     input: "./public-key.pem",
 * }).then(invoke => invoke.result)});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.ivs.PlaybackKeyPair("example", public_key=std.file(input="./public-key.pem").result)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ivs.PlaybackKeyPair("example", new()
 *     {
 *         PublicKey = Std.File.Invoke(new()
 *         {
 *             Input = "./public-key.pem",
 *         }).Apply(invoke => invoke.Result),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ivs"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "./public-key.pem",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ivs.NewPlaybackKeyPair(ctx, "example", &ivs.PlaybackKeyPairArgs{
 * 			PublicKey: pulumi.String(invokeFile.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ivs.PlaybackKeyPair;
 * import com.pulumi.aws.ivs.PlaybackKeyPairArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PlaybackKeyPair("example", PlaybackKeyPairArgs.builder()
 *             .publicKey(StdFunctions.file(FileArgs.builder()
 *                 .input("./public-key.pem")
 *                 .build()).result())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ivs:PlaybackKeyPair
 *     properties:
 *       publicKey:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: ./public-key.pem
 *           Return: result
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IVS (Interactive Video) Playback Key Pair using the ARN. For example:
 * ```sh
 * $ pulumi import aws:ivs/playbackKeyPair:PlaybackKeyPair example arn:aws:ivs:us-west-2:326937407773:playback-key/KDJRJNQhiQzA
 * ```
 * @property name Playback Key Pair name.
 * @property publicKey Public portion of a customer-generated key pair. Must be an ECDSA public key in PEM format.
 * The following arguments are optional:
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class PlaybackKeyPairArgs(
    public val name: Output<String>? = null,
    public val publicKey: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ivs.PlaybackKeyPairArgs> {
    override fun toJava(): com.pulumi.aws.ivs.PlaybackKeyPairArgs =
        com.pulumi.aws.ivs.PlaybackKeyPairArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .publicKey(publicKey?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PlaybackKeyPairArgs].
 */
@PulumiTagMarker
public class PlaybackKeyPairArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var publicKey: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Playback Key Pair name.
     */
    @JvmName("ldaekmijhswsqglf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Public portion of a customer-generated key pair. Must be an ECDSA public key in PEM format.
     * The following arguments are optional:
     */
    @JvmName("fteagiyoenystixt")
    public suspend fun publicKey(`value`: Output<String>) {
        this.publicKey = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("brlsbvsxtkmvvgxa")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Playback Key Pair name.
     */
    @JvmName("llqhudhhqhfheawl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Public portion of a customer-generated key pair. Must be an ECDSA public key in PEM format.
     * The following arguments are optional:
     */
    @JvmName("xemfgjkiojggsswk")
    public suspend fun publicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKey = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wfoiyvqjmjtoaqem")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fpbputgwxnhjklnj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PlaybackKeyPairArgs = PlaybackKeyPairArgs(
        name = name,
        publicKey = publicKey,
        tags = tags,
    )
}
