@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivs.kotlin

import com.pulumi.aws.ivs.kotlin.outputs.RecordingConfigurationDestinationConfiguration
import com.pulumi.aws.ivs.kotlin.outputs.RecordingConfigurationThumbnailConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.ivs.kotlin.outputs.RecordingConfigurationDestinationConfiguration.Companion.toKotlin as recordingConfigurationDestinationConfigurationToKotlin
import com.pulumi.aws.ivs.kotlin.outputs.RecordingConfigurationThumbnailConfiguration.Companion.toKotlin as recordingConfigurationThumbnailConfigurationToKotlin

/**
 * Builder for [RecordingConfiguration].
 */
@PulumiTagMarker
public class RecordingConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RecordingConfigurationArgs = RecordingConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RecordingConfigurationArgsBuilder.() -> Unit) {
        val builder = RecordingConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RecordingConfiguration {
        val builtJavaResource = com.pulumi.aws.ivs.RecordingConfiguration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RecordingConfiguration(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS IVS (Interactive Video) Recording Configuration.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ivs.RecordingConfiguration("example", {
 *     name: "recording_configuration-1",
 *     destinationConfiguration: {
 *         s3: {
 *             bucketName: "ivs-stream-archive",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ivs.RecordingConfiguration("example",
 *     name="recording_configuration-1",
 *     destination_configuration={
 *         "s3": {
 *             "bucket_name": "ivs-stream-archive",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ivs.RecordingConfiguration("example", new()
 *     {
 *         Name = "recording_configuration-1",
 *         DestinationConfiguration = new Aws.Ivs.Inputs.RecordingConfigurationDestinationConfigurationArgs
 *         {
 *             S3 = new Aws.Ivs.Inputs.RecordingConfigurationDestinationConfigurationS3Args
 *             {
 *                 BucketName = "ivs-stream-archive",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ivs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ivs.NewRecordingConfiguration(ctx, "example", &ivs.RecordingConfigurationArgs{
 * 			Name: pulumi.String("recording_configuration-1"),
 * 			DestinationConfiguration: &ivs.RecordingConfigurationDestinationConfigurationArgs{
 * 				S3: &ivs.RecordingConfigurationDestinationConfigurationS3Args{
 * 					BucketName: pulumi.String("ivs-stream-archive"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ivs.RecordingConfiguration;
 * import com.pulumi.aws.ivs.RecordingConfigurationArgs;
 * import com.pulumi.aws.ivs.inputs.RecordingConfigurationDestinationConfigurationArgs;
 * import com.pulumi.aws.ivs.inputs.RecordingConfigurationDestinationConfigurationS3Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RecordingConfiguration("example", RecordingConfigurationArgs.builder()
 *             .name("recording_configuration-1")
 *             .destinationConfiguration(RecordingConfigurationDestinationConfigurationArgs.builder()
 *                 .s3(RecordingConfigurationDestinationConfigurationS3Args.builder()
 *                     .bucketName("ivs-stream-archive")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ivs:RecordingConfiguration
 *     properties:
 *       name: recording_configuration-1
 *       destinationConfiguration:
 *         s3:
 *           bucketName: ivs-stream-archive
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IVS (Interactive Video) Recording Configuration using the ARN. For example:
 * ```sh
 * $ pulumi import aws:ivs/recordingConfiguration:RecordingConfiguration example arn:aws:ivs:us-west-2:326937407773:recording-configuration/KAk1sHBl2L47
 * ```
 */
public class RecordingConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.ivs.RecordingConfiguration,
) : KotlinCustomResource(javaResource, RecordingConfigurationMapper) {
    /**
     * ARN of the Recording Configuration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Object containing destination configuration for where recorded video will be stored.
     */
    public val destinationConfiguration: Output<RecordingConfigurationDestinationConfiguration>
        get() = javaResource.destinationConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                recordingConfigurationDestinationConfigurationToKotlin(args0)
            })
        })

    /**
     * Recording Configuration name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * If a broadcast disconnects and then reconnects within the specified interval, the multiple streams will be considered a single broadcast and merged together.
     */
    public val recordingReconnectWindowSeconds: Output<Int>
        get() = javaResource.recordingReconnectWindowSeconds().applyValue({ args0 -> args0 })

    /**
     * The current state of the Recording Configuration.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Object containing information to enable/disable the recording of thumbnails for a live session and modify the interval at which thumbnails are generated for the live session.
     */
    public val thumbnailConfiguration: Output<RecordingConfigurationThumbnailConfiguration>
        get() = javaResource.thumbnailConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                recordingConfigurationThumbnailConfigurationToKotlin(args0)
            })
        })
}

public object RecordingConfigurationMapper : ResourceMapper<RecordingConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ivs.RecordingConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): RecordingConfiguration =
        RecordingConfiguration(javaResource as com.pulumi.aws.ivs.RecordingConfiguration)
}

/**
 * @see [RecordingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RecordingConfiguration].
 */
public suspend fun recordingConfiguration(
    name: String,
    block: suspend RecordingConfigurationResourceBuilder.() -> Unit,
): RecordingConfiguration {
    val builder = RecordingConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RecordingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun recordingConfiguration(name: String): RecordingConfiguration {
    val builder = RecordingConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
