@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivs.kotlin

import com.pulumi.aws.ivs.RecordingConfigurationArgs.builder
import com.pulumi.aws.ivs.kotlin.inputs.RecordingConfigurationDestinationConfigurationArgs
import com.pulumi.aws.ivs.kotlin.inputs.RecordingConfigurationDestinationConfigurationArgsBuilder
import com.pulumi.aws.ivs.kotlin.inputs.RecordingConfigurationThumbnailConfigurationArgs
import com.pulumi.aws.ivs.kotlin.inputs.RecordingConfigurationThumbnailConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS IVS (Interactive Video) Recording Configuration.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ivs.RecordingConfiguration("example", {
 *     name: "recording_configuration-1",
 *     destinationConfiguration: {
 *         s3: {
 *             bucketName: "ivs-stream-archive",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ivs.RecordingConfiguration("example",
 *     name="recording_configuration-1",
 *     destination_configuration={
 *         "s3": {
 *             "bucket_name": "ivs-stream-archive",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ivs.RecordingConfiguration("example", new()
 *     {
 *         Name = "recording_configuration-1",
 *         DestinationConfiguration = new Aws.Ivs.Inputs.RecordingConfigurationDestinationConfigurationArgs
 *         {
 *             S3 = new Aws.Ivs.Inputs.RecordingConfigurationDestinationConfigurationS3Args
 *             {
 *                 BucketName = "ivs-stream-archive",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ivs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ivs.NewRecordingConfiguration(ctx, "example", &ivs.RecordingConfigurationArgs{
 * 			Name: pulumi.String("recording_configuration-1"),
 * 			DestinationConfiguration: &ivs.RecordingConfigurationDestinationConfigurationArgs{
 * 				S3: &ivs.RecordingConfigurationDestinationConfigurationS3Args{
 * 					BucketName: pulumi.String("ivs-stream-archive"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ivs.RecordingConfiguration;
 * import com.pulumi.aws.ivs.RecordingConfigurationArgs;
 * import com.pulumi.aws.ivs.inputs.RecordingConfigurationDestinationConfigurationArgs;
 * import com.pulumi.aws.ivs.inputs.RecordingConfigurationDestinationConfigurationS3Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RecordingConfiguration("example", RecordingConfigurationArgs.builder()
 *             .name("recording_configuration-1")
 *             .destinationConfiguration(RecordingConfigurationDestinationConfigurationArgs.builder()
 *                 .s3(RecordingConfigurationDestinationConfigurationS3Args.builder()
 *                     .bucketName("ivs-stream-archive")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ivs:RecordingConfiguration
 *     properties:
 *       name: recording_configuration-1
 *       destinationConfiguration:
 *         s3:
 *           bucketName: ivs-stream-archive
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IVS (Interactive Video) Recording Configuration using the ARN. For example:
 * ```sh
 * $ pulumi import aws:ivs/recordingConfiguration:RecordingConfiguration example arn:aws:ivs:us-west-2:326937407773:recording-configuration/KAk1sHBl2L47
 * ```
 * @property destinationConfiguration Object containing destination configuration for where recorded video will be stored.
 * @property name Recording Configuration name.
 * @property recordingReconnectWindowSeconds If a broadcast disconnects and then reconnects within the specified interval, the multiple streams will be considered a single broadcast and merged together.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property thumbnailConfiguration Object containing information to enable/disable the recording of thumbnails for a live session and modify the interval at which thumbnails are generated for the live session.
 */
public data class RecordingConfigurationArgs(
    public val destinationConfiguration: Output<RecordingConfigurationDestinationConfigurationArgs>? =
        null,
    public val name: Output<String>? = null,
    public val recordingReconnectWindowSeconds: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val thumbnailConfiguration: Output<RecordingConfigurationThumbnailConfigurationArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.ivs.RecordingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ivs.RecordingConfigurationArgs =
        com.pulumi.aws.ivs.RecordingConfigurationArgs.builder()
            .destinationConfiguration(
                destinationConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .recordingReconnectWindowSeconds(recordingReconnectWindowSeconds?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .thumbnailConfiguration(
                thumbnailConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [RecordingConfigurationArgs].
 */
@PulumiTagMarker
public class RecordingConfigurationArgsBuilder internal constructor() {
    private var destinationConfiguration: Output<RecordingConfigurationDestinationConfigurationArgs>? =
        null

    private var name: Output<String>? = null

    private var recordingReconnectWindowSeconds: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var thumbnailConfiguration: Output<RecordingConfigurationThumbnailConfigurationArgs>? =
        null

    /**
     * @param value Object containing destination configuration for where recorded video will be stored.
     */
    @JvmName("jwjdnettggukntne")
    public suspend fun destinationConfiguration(`value`: Output<RecordingConfigurationDestinationConfigurationArgs>) {
        this.destinationConfiguration = value
    }

    /**
     * @param value Recording Configuration name.
     */
    @JvmName("okcrffjifwgmvbib")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value If a broadcast disconnects and then reconnects within the specified interval, the multiple streams will be considered a single broadcast and merged together.
     */
    @JvmName("bnswfvlboqlrnlwt")
    public suspend fun recordingReconnectWindowSeconds(`value`: Output<Int>) {
        this.recordingReconnectWindowSeconds = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kairsnujnfmmntaf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Object containing information to enable/disable the recording of thumbnails for a live session and modify the interval at which thumbnails are generated for the live session.
     */
    @JvmName("rqevfqxymtdxihwg")
    public suspend fun thumbnailConfiguration(`value`: Output<RecordingConfigurationThumbnailConfigurationArgs>) {
        this.thumbnailConfiguration = value
    }

    /**
     * @param value Object containing destination configuration for where recorded video will be stored.
     */
    @JvmName("xmpuaemifpbbbjnp")
    public suspend fun destinationConfiguration(`value`: RecordingConfigurationDestinationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationConfiguration = mapped
    }

    /**
     * @param argument Object containing destination configuration for where recorded video will be stored.
     */
    @JvmName("vsgottjxxdnqfeyt")
    public suspend fun destinationConfiguration(argument: suspend RecordingConfigurationDestinationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = RecordingConfigurationDestinationConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.destinationConfiguration = mapped
    }

    /**
     * @param value Recording Configuration name.
     */
    @JvmName("hsjxyhkxeetytoqw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value If a broadcast disconnects and then reconnects within the specified interval, the multiple streams will be considered a single broadcast and merged together.
     */
    @JvmName("uxvsfmlwtuklqwfm")
    public suspend fun recordingReconnectWindowSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordingReconnectWindowSeconds = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("icfyxmiiogkwtxdb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hbldsfaiooalvfko")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Object containing information to enable/disable the recording of thumbnails for a live session and modify the interval at which thumbnails are generated for the live session.
     */
    @JvmName("siumnixggrvrhcrg")
    public suspend fun thumbnailConfiguration(`value`: RecordingConfigurationThumbnailConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thumbnailConfiguration = mapped
    }

    /**
     * @param argument Object containing information to enable/disable the recording of thumbnails for a live session and modify the interval at which thumbnails are generated for the live session.
     */
    @JvmName("gyrcscgjfolwbwjv")
    public suspend fun thumbnailConfiguration(argument: suspend RecordingConfigurationThumbnailConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = RecordingConfigurationThumbnailConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.thumbnailConfiguration = mapped
    }

    internal fun build(): RecordingConfigurationArgs = RecordingConfigurationArgs(
        destinationConfiguration = destinationConfiguration,
        name = name,
        recordingReconnectWindowSeconds = recordingReconnectWindowSeconds,
        tags = tags,
        thumbnailConfiguration = thumbnailConfiguration,
    )
}
