@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivs.kotlin.inputs

import com.pulumi.aws.ivs.inputs.GetStreamKeyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getStreamKey.
 * @property channelArn ARN of the Channel.
 * @property tags Map of tags assigned to the resource.
 */
public data class GetStreamKeyPlainArgs(
    public val channelArn: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ivs.inputs.GetStreamKeyPlainArgs> {
    override fun toJava(): com.pulumi.aws.ivs.inputs.GetStreamKeyPlainArgs =
        com.pulumi.aws.ivs.inputs.GetStreamKeyPlainArgs.builder()
            .channelArn(channelArn.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetStreamKeyPlainArgs].
 */
@PulumiTagMarker
public class GetStreamKeyPlainArgsBuilder internal constructor() {
    private var channelArn: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ARN of the Channel.
     */
    @JvmName("npktroxawcviqyjk")
    public suspend fun channelArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.channelArn = mapped
    }

    /**
     * @param value Map of tags assigned to the resource.
     */
    @JvmName("iddcvipvrnjcxkdf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the resource.
     */
    @JvmName("kufxbxfdcflxfvdg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetStreamKeyPlainArgs = GetStreamKeyPlainArgs(
        channelArn = channelArn ?: throw PulumiNullFieldException("channelArn"),
        tags = tags,
    )
}
