@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivs.kotlin.inputs

import com.pulumi.aws.ivs.inputs.RecordingConfigurationDestinationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property s3 S3 destination configuration where recorded videos will be stored.
 */
public data class RecordingConfigurationDestinationConfigurationArgs(
    public val s3: Output<RecordingConfigurationDestinationConfigurationS3Args>,
) : ConvertibleToJava<com.pulumi.aws.ivs.inputs.RecordingConfigurationDestinationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ivs.inputs.RecordingConfigurationDestinationConfigurationArgs =
        com.pulumi.aws.ivs.inputs.RecordingConfigurationDestinationConfigurationArgs.builder()
            .s3(s3.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RecordingConfigurationDestinationConfigurationArgs].
 */
@PulumiTagMarker
public class RecordingConfigurationDestinationConfigurationArgsBuilder internal constructor() {
    private var s3: Output<RecordingConfigurationDestinationConfigurationS3Args>? = null

    /**
     * @param value S3 destination configuration where recorded videos will be stored.
     */
    @JvmName("oilmhahubnpbigrm")
    public suspend fun s3(`value`: Output<RecordingConfigurationDestinationConfigurationS3Args>) {
        this.s3 = value
    }

    /**
     * @param value S3 destination configuration where recorded videos will be stored.
     */
    @JvmName("iaughbmbfasdphii")
    public suspend fun s3(`value`: RecordingConfigurationDestinationConfigurationS3Args) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3 = mapped
    }

    /**
     * @param argument S3 destination configuration where recorded videos will be stored.
     */
    @JvmName("hiaotkiforgmvxlv")
    public suspend fun s3(argument: suspend RecordingConfigurationDestinationConfigurationS3ArgsBuilder.() -> Unit) {
        val toBeMapped = RecordingConfigurationDestinationConfigurationS3ArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3 = mapped
    }

    internal fun build(): RecordingConfigurationDestinationConfigurationArgs =
        RecordingConfigurationDestinationConfigurationArgs(
            s3 = s3 ?: throw PulumiNullFieldException("s3"),
        )
}
