@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivs.kotlin.inputs

import com.pulumi.aws.ivs.inputs.RecordingConfigurationDestinationConfigurationS3Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName S3 bucket name where recorded videos will be stored.
 * The following arguments are optional:
 */
public data class RecordingConfigurationDestinationConfigurationS3Args(
    public val bucketName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.ivs.inputs.RecordingConfigurationDestinationConfigurationS3Args> {
    override fun toJava(): com.pulumi.aws.ivs.inputs.RecordingConfigurationDestinationConfigurationS3Args =
        com.pulumi.aws.ivs.inputs.RecordingConfigurationDestinationConfigurationS3Args.builder()
            .bucketName(bucketName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecordingConfigurationDestinationConfigurationS3Args].
 */
@PulumiTagMarker
public class RecordingConfigurationDestinationConfigurationS3ArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    /**
     * @param value S3 bucket name where recorded videos will be stored.
     * The following arguments are optional:
     */
    @JvmName("frahrmsswurrrsmg")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value S3 bucket name where recorded videos will be stored.
     * The following arguments are optional:
     */
    @JvmName("kfmmdcggoqilsnrl")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    internal fun build(): RecordingConfigurationDestinationConfigurationS3Args =
        RecordingConfigurationDestinationConfigurationS3Args(
            bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
        )
}
