@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivs.kotlin.inputs

import com.pulumi.aws.ivs.inputs.RecordingConfigurationThumbnailConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property recordingMode Thumbnail recording mode. Valid values: `DISABLED`, `INTERVAL`.
 * @property targetIntervalSeconds The targeted thumbnail-generation interval in seconds.
 */
public data class RecordingConfigurationThumbnailConfigurationArgs(
    public val recordingMode: Output<String>? = null,
    public val targetIntervalSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.ivs.inputs.RecordingConfigurationThumbnailConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ivs.inputs.RecordingConfigurationThumbnailConfigurationArgs = com.pulumi.aws.ivs.inputs.RecordingConfigurationThumbnailConfigurationArgs.builder()
        .recordingMode(recordingMode?.applyValue({ args0 -> args0 }))
        .targetIntervalSeconds(targetIntervalSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecordingConfigurationThumbnailConfigurationArgs].
 */
@PulumiTagMarker
public class RecordingConfigurationThumbnailConfigurationArgsBuilder internal constructor() {
    private var recordingMode: Output<String>? = null

    private var targetIntervalSeconds: Output<Int>? = null

    /**
     * @param value Thumbnail recording mode. Valid values: `DISABLED`, `INTERVAL`.
     */
    @JvmName("hchqpxtrjtdmqeic")
    public suspend fun recordingMode(`value`: Output<String>) {
        this.recordingMode = value
    }

    /**
     * @param value The targeted thumbnail-generation interval in seconds.
     */
    @JvmName("drsbvccguigmldkl")
    public suspend fun targetIntervalSeconds(`value`: Output<Int>) {
        this.targetIntervalSeconds = value
    }

    /**
     * @param value Thumbnail recording mode. Valid values: `DISABLED`, `INTERVAL`.
     */
    @JvmName("mmcjsapblmccgxiu")
    public suspend fun recordingMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordingMode = mapped
    }

    /**
     * @param value The targeted thumbnail-generation interval in seconds.
     */
    @JvmName("qgsiymluclupqsbm")
    public suspend fun targetIntervalSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetIntervalSeconds = mapped
    }

    internal fun build(): RecordingConfigurationThumbnailConfigurationArgs =
        RecordingConfigurationThumbnailConfigurationArgs(
            recordingMode = recordingMode,
            targetIntervalSeconds = targetIntervalSeconds,
        )
}
