@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property recordingMode Thumbnail recording mode. Valid values: `DISABLED`, `INTERVAL`.
 * @property targetIntervalSeconds The targeted thumbnail-generation interval in seconds.
 */
public data class RecordingConfigurationThumbnailConfiguration(
    public val recordingMode: String? = null,
    public val targetIntervalSeconds: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ivs.outputs.RecordingConfigurationThumbnailConfiguration): RecordingConfigurationThumbnailConfiguration = RecordingConfigurationThumbnailConfiguration(
            recordingMode = javaType.recordingMode().map({ args0 -> args0 }).orElse(null),
            targetIntervalSeconds = javaType.targetIntervalSeconds().map({ args0 -> args0 }).orElse(null),
        )
    }
}
