@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivschat.kotlin

import com.pulumi.aws.ivschat.kotlin.outputs.LoggingConfigurationDestinationConfiguration
import com.pulumi.aws.ivschat.kotlin.outputs.LoggingConfigurationDestinationConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [LoggingConfiguration].
 */
@PulumiTagMarker
public class LoggingConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LoggingConfigurationArgs = LoggingConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LoggingConfigurationArgsBuilder.() -> Unit) {
        val builder = LoggingConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LoggingConfiguration {
        val builtJavaResource = com.pulumi.aws.ivschat.LoggingConfiguration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LoggingConfiguration(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS IVS (Interactive Video) Chat Logging Configuration.
 * ## Example Usage
 * ### Basic Usage - Logging to CloudWatch
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudwatch.LogGroup("example", {});
 * const exampleLoggingConfiguration = new aws.ivschat.LoggingConfiguration("example", {destinationConfiguration: {
 *     cloudwatchLogs: {
 *         logGroupName: example.name,
 *     },
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudwatch.LogGroup("example")
 * example_logging_configuration = aws.ivschat.LoggingConfiguration("example", destination_configuration={
 *     "cloudwatch_logs": {
 *         "log_group_name": example.name,
 *     },
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudWatch.LogGroup("example");
 *     var exampleLoggingConfiguration = new Aws.IvsChat.LoggingConfiguration("example", new()
 *     {
 *         DestinationConfiguration = new Aws.IvsChat.Inputs.LoggingConfigurationDestinationConfigurationArgs
 *         {
 *             CloudwatchLogs = new Aws.IvsChat.Inputs.LoggingConfigurationDestinationConfigurationCloudwatchLogsArgs
 *             {
 *                 LogGroupName = example.Name,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ivschat"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cloudwatch.NewLogGroup(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ivschat.NewLoggingConfiguration(ctx, "example", &ivschat.LoggingConfigurationArgs{
 * 			DestinationConfiguration: &ivschat.LoggingConfigurationDestinationConfigurationArgs{
 * 				CloudwatchLogs: &ivschat.LoggingConfigurationDestinationConfigurationCloudwatchLogsArgs{
 * 					LogGroupName: example.Name,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.ivschat.LoggingConfiguration;
 * import com.pulumi.aws.ivschat.LoggingConfigurationArgs;
 * import com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationArgs;
 * import com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationCloudwatchLogsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LogGroup("example");
 *         var exampleLoggingConfiguration = new LoggingConfiguration("exampleLoggingConfiguration", LoggingConfigurationArgs.builder()
 *             .destinationConfiguration(LoggingConfigurationDestinationConfigurationArgs.builder()
 *                 .cloudwatchLogs(LoggingConfigurationDestinationConfigurationCloudwatchLogsArgs.builder()
 *                     .logGroupName(example.name())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudwatch:LogGroup
 *   exampleLoggingConfiguration:
 *     type: aws:ivschat:LoggingConfiguration
 *     name: example
 *     properties:
 *       destinationConfiguration:
 *         cloudwatchLogs:
 *           logGroupName: ${example.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic Usage - Logging to Kinesis Firehose with Extended S3
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleBucketV2 = new aws.s3.BucketV2("example", {bucketPrefix: "tf-ivschat-logging-bucket"});
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["firehose&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const exampleRole = new aws.iam.Role("example", {
 *     name: "firehose_example_role",
 *     assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json),
 * });
 * const example = new aws.kinesis.FirehoseDeliveryStream("example", {
 *     name: "pulumi-kinesis-firehose-extended-s3-example-stream",
 *     destination: "extended_s3",
 *     extendedS3Configuration: {
 *         roleArn: exampleRole.arn,
 *         bucketArn: exampleBucketV2.arn,
 *     },
 *     tags: {
 *         LogDeliveryEnabled: "true",
 *     },
 * });
 * const exampleBucketAclV2 = new aws.s3.BucketAclV2("example", {
 *     bucket: exampleBucketV2.id,
 *     acl: "private",
 * });
 * const exampleLoggingConfiguration = new aws.ivschat.LoggingConfiguration("example", {destinationConfiguration: {
 *     firehose: {
 *         deliveryStreamName: example.name,
 *     },
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_bucket_v2 = aws.s3.BucketV2("example", bucket_prefix="tf-ivschat-logging-bucket")
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["firehose&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * example_role = aws.iam.Role("example",
 *     name="firehose_example_role",
 *     assume_role_policy=assume_role.json)
 * example = aws.kinesis.FirehoseDeliveryStream("example",
 *     name="pulumi-kinesis-firehose-extended-s3-example-stream",
 *     destination="extended_s3",
 *     extended_s3_configuration={
 *         "role_arn": example_role.arn,
 *         "bucket_arn": example_bucket_v2.arn,
 *     },
 *     tags={
 *         "LogDeliveryEnabled": "true",
 *     })
 * example_bucket_acl_v2 = aws.s3.BucketAclV2("example",
 *     bucket=example_bucket_v2.id,
 *     acl="private")
 * example_logging_configuration = aws.ivschat.LoggingConfiguration("example", destination_configuration={
 *     "firehose": {
 *         "delivery_stream_name": example.name,
 *     },
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleBucketV2 = new Aws.S3.BucketV2("example", new()
 *     {
 *         BucketPrefix = "tf-ivschat-logging-bucket",
 *     });
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "firehose.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRole = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "firehose_example_role",
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var example = new Aws.Kinesis.FirehoseDeliveryStream("example", new()
 *     {
 *         Name = "pulumi-kinesis-firehose-extended-s3-example-stream",
 *         Destination = "extended_s3",
 *         ExtendedS3Configuration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs
 *         {
 *             RoleArn = exampleRole.Arn,
 *             BucketArn = exampleBucketV2.Arn,
 *         },
 *         Tags =
 *         {
 *             { "LogDeliveryEnabled", "true" },
 *         },
 *     });
 *     var exampleBucketAclV2 = new Aws.S3.BucketAclV2("example", new()
 *     {
 *         Bucket = exampleBucketV2.Id,
 *         Acl = "private",
 *     });
 *     var exampleLoggingConfiguration = new Aws.IvsChat.LoggingConfiguration("example", new()
 *     {
 *         DestinationConfiguration = new Aws.IvsChat.Inputs.LoggingConfigurationDestinationConfigurationArgs
 *         {
 *             Firehose = new Aws.IvsChat.Inputs.LoggingConfigurationDestinationConfigurationFirehoseArgs
 *             {
 *                 DeliveryStreamName = example.Name,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ivschat"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kinesis"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleBucketV2, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			BucketPrefix: pulumi.String("tf-ivschat-logging-bucket"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"firehose.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleRole, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			Name:             pulumi.String("firehose_example_role"),
 * 			AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := kinesis.NewFirehoseDeliveryStream(ctx, "example", &kinesis.FirehoseDeliveryStreamArgs{
 * 			Name:        pulumi.String("pulumi-kinesis-firehose-extended-s3-example-stream"),
 * 			Destination: pulumi.String("extended_s3"),
 * 			ExtendedS3Configuration: &kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationArgs{
 * 				RoleArn:   exampleRole.Arn,
 * 				BucketArn: exampleBucketV2.Arn,
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"LogDeliveryEnabled": pulumi.String("true"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketAclV2(ctx, "example", &s3.BucketAclV2Args{
 * 			Bucket: exampleBucketV2.ID(),
 * 			Acl:    pulumi.String("private"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ivschat.NewLoggingConfiguration(ctx, "example", &ivschat.LoggingConfigurationArgs{
 * 			DestinationConfiguration: &ivschat.LoggingConfigurationDestinationConfigurationArgs{
 * 				Firehose: &ivschat.LoggingConfigurationDestinationConfigurationFirehoseArgs{
 * 					DeliveryStreamName: example.Name,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.ivschat.LoggingConfiguration;
 * import com.pulumi.aws.ivschat.LoggingConfigurationArgs;
 * import com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationArgs;
 * import com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationFirehoseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .bucketPrefix("tf-ivschat-logging-bucket")
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("firehose.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .name("firehose_example_role")
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var example = new FirehoseDeliveryStream("example", FirehoseDeliveryStreamArgs.builder()
 *             .name("pulumi-kinesis-firehose-extended-s3-example-stream")
 *             .destination("extended_s3")
 *             .extendedS3Configuration(FirehoseDeliveryStreamExtendedS3ConfigurationArgs.builder()
 *                 .roleArn(exampleRole.arn())
 *                 .bucketArn(exampleBucketV2.arn())
 *                 .build())
 *             .tags(Map.of("LogDeliveryEnabled", "true"))
 *             .build());
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .acl("private")
 *             .build());
 *         var exampleLoggingConfiguration = new LoggingConfiguration("exampleLoggingConfiguration", LoggingConfigurationArgs.builder()
 *             .destinationConfiguration(LoggingConfigurationDestinationConfigurationArgs.builder()
 *                 .firehose(LoggingConfigurationDestinationConfigurationFirehoseArgs.builder()
 *                     .deliveryStreamName(example.name())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kinesis:FirehoseDeliveryStream
 *     properties:
 *       name: pulumi-kinesis-firehose-extended-s3-example-stream
 *       destination: extended_s3
 *       extendedS3Configuration:
 *         roleArn: ${exampleRole.arn}
 *         bucketArn: ${exampleBucketV2.arn}
 *       tags:
 *         LogDeliveryEnabled: 'true'
 *   exampleBucketV2:
 *     type: aws:s3:BucketV2
 *     name: example
 *     properties:
 *       bucketPrefix: tf-ivschat-logging-bucket
 *   exampleBucketAclV2:
 *     type: aws:s3:BucketAclV2
 *     name: example
 *     properties:
 *       bucket: ${exampleBucketV2.id}
 *       acl: private
 *   exampleRole:
 *     type: aws:iam:Role
 *     name: example
 *     properties:
 *       name: firehose_example_role
 *       assumeRolePolicy: ${assumeRole.json}
 *   exampleLoggingConfiguration:
 *     type: aws:ivschat:LoggingConfiguration
 *     name: example
 *     properties:
 *       destinationConfiguration:
 *         firehose:
 *           deliveryStreamName: ${example.name}
 * variables:
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - firehose.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic Usage - Logging to S3
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucketName: tf-ivschat-logging
 *       forceDestroy: true
 *   exampleLoggingConfiguration:
 *     type: aws:ivschat:LoggingConfiguration
 *     name: example
 *     properties:
 *       destinationConfiguration:
 *         s3:
 *           bucketName: ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IVS (Interactive Video) Chat Logging Configuration using the ARN. For example:
 * ```sh
 * $ pulumi import aws:ivschat/loggingConfiguration:LoggingConfiguration example arn:aws:ivschat:us-west-2:326937407773:logging-configuration/MMUQc8wcqZmC
 * ```
 */
public class LoggingConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.ivschat.LoggingConfiguration,
) : KotlinCustomResource(javaResource, LoggingConfigurationMapper) {
    /**
     * ARN of the Logging Configuration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Object containing destination configuration for where chat activity will be logged. This object must contain exactly one of the following children arguments:
     */
    public val destinationConfiguration: Output<LoggingConfigurationDestinationConfiguration>?
        get() = javaResource.destinationConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Logging Configuration name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * State of the Logging Configuration.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object LoggingConfigurationMapper : ResourceMapper<LoggingConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ivschat.LoggingConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): LoggingConfiguration = LoggingConfiguration(
        javaResource
            as com.pulumi.aws.ivschat.LoggingConfiguration,
    )
}

/**
 * @see [LoggingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LoggingConfiguration].
 */
public suspend fun loggingConfiguration(
    name: String,
    block: suspend LoggingConfigurationResourceBuilder.() -> Unit,
): LoggingConfiguration {
    val builder = LoggingConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LoggingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun loggingConfiguration(name: String): LoggingConfiguration {
    val builder = LoggingConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
