@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivschat.kotlin

import com.pulumi.aws.ivschat.LoggingConfigurationArgs.builder
import com.pulumi.aws.ivschat.kotlin.inputs.LoggingConfigurationDestinationConfigurationArgs
import com.pulumi.aws.ivschat.kotlin.inputs.LoggingConfigurationDestinationConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS IVS (Interactive Video) Chat Logging Configuration.
 * ## Example Usage
 * ### Basic Usage - Logging to CloudWatch
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudwatch.LogGroup("example", {});
 * const exampleLoggingConfiguration = new aws.ivschat.LoggingConfiguration("example", {destinationConfiguration: {
 *     cloudwatchLogs: {
 *         logGroupName: example.name,
 *     },
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudwatch.LogGroup("example")
 * example_logging_configuration = aws.ivschat.LoggingConfiguration("example", destination_configuration={
 *     "cloudwatch_logs": {
 *         "log_group_name": example.name,
 *     },
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudWatch.LogGroup("example");
 *     var exampleLoggingConfiguration = new Aws.IvsChat.LoggingConfiguration("example", new()
 *     {
 *         DestinationConfiguration = new Aws.IvsChat.Inputs.LoggingConfigurationDestinationConfigurationArgs
 *         {
 *             CloudwatchLogs = new Aws.IvsChat.Inputs.LoggingConfigurationDestinationConfigurationCloudwatchLogsArgs
 *             {
 *                 LogGroupName = example.Name,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ivschat"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cloudwatch.NewLogGroup(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ivschat.NewLoggingConfiguration(ctx, "example", &ivschat.LoggingConfigurationArgs{
 * 			DestinationConfiguration: &ivschat.LoggingConfigurationDestinationConfigurationArgs{
 * 				CloudwatchLogs: &ivschat.LoggingConfigurationDestinationConfigurationCloudwatchLogsArgs{
 * 					LogGroupName: example.Name,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.ivschat.LoggingConfiguration;
 * import com.pulumi.aws.ivschat.LoggingConfigurationArgs;
 * import com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationArgs;
 * import com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationCloudwatchLogsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LogGroup("example");
 *         var exampleLoggingConfiguration = new LoggingConfiguration("exampleLoggingConfiguration", LoggingConfigurationArgs.builder()
 *             .destinationConfiguration(LoggingConfigurationDestinationConfigurationArgs.builder()
 *                 .cloudwatchLogs(LoggingConfigurationDestinationConfigurationCloudwatchLogsArgs.builder()
 *                     .logGroupName(example.name())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudwatch:LogGroup
 *   exampleLoggingConfiguration:
 *     type: aws:ivschat:LoggingConfiguration
 *     name: example
 *     properties:
 *       destinationConfiguration:
 *         cloudwatchLogs:
 *           logGroupName: ${example.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic Usage - Logging to Kinesis Firehose with Extended S3
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleBucketV2 = new aws.s3.BucketV2("example", {bucketPrefix: "tf-ivschat-logging-bucket"});
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["firehose&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const exampleRole = new aws.iam.Role("example", {
 *     name: "firehose_example_role",
 *     assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json),
 * });
 * const example = new aws.kinesis.FirehoseDeliveryStream("example", {
 *     name: "pulumi-kinesis-firehose-extended-s3-example-stream",
 *     destination: "extended_s3",
 *     extendedS3Configuration: {
 *         roleArn: exampleRole.arn,
 *         bucketArn: exampleBucketV2.arn,
 *     },
 *     tags: {
 *         LogDeliveryEnabled: "true",
 *     },
 * });
 * const exampleBucketAclV2 = new aws.s3.BucketAclV2("example", {
 *     bucket: exampleBucketV2.id,
 *     acl: "private",
 * });
 * const exampleLoggingConfiguration = new aws.ivschat.LoggingConfiguration("example", {destinationConfiguration: {
 *     firehose: {
 *         deliveryStreamName: example.name,
 *     },
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_bucket_v2 = aws.s3.BucketV2("example", bucket_prefix="tf-ivschat-logging-bucket")
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["firehose&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * example_role = aws.iam.Role("example",
 *     name="firehose_example_role",
 *     assume_role_policy=assume_role.json)
 * example = aws.kinesis.FirehoseDeliveryStream("example",
 *     name="pulumi-kinesis-firehose-extended-s3-example-stream",
 *     destination="extended_s3",
 *     extended_s3_configuration={
 *         "role_arn": example_role.arn,
 *         "bucket_arn": example_bucket_v2.arn,
 *     },
 *     tags={
 *         "LogDeliveryEnabled": "true",
 *     })
 * example_bucket_acl_v2 = aws.s3.BucketAclV2("example",
 *     bucket=example_bucket_v2.id,
 *     acl="private")
 * example_logging_configuration = aws.ivschat.LoggingConfiguration("example", destination_configuration={
 *     "firehose": {
 *         "delivery_stream_name": example.name,
 *     },
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleBucketV2 = new Aws.S3.BucketV2("example", new()
 *     {
 *         BucketPrefix = "tf-ivschat-logging-bucket",
 *     });
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "firehose.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRole = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "firehose_example_role",
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var example = new Aws.Kinesis.FirehoseDeliveryStream("example", new()
 *     {
 *         Name = "pulumi-kinesis-firehose-extended-s3-example-stream",
 *         Destination = "extended_s3",
 *         ExtendedS3Configuration = new Aws.Kinesis.Inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs
 *         {
 *             RoleArn = exampleRole.Arn,
 *             BucketArn = exampleBucketV2.Arn,
 *         },
 *         Tags =
 *         {
 *             { "LogDeliveryEnabled", "true" },
 *         },
 *     });
 *     var exampleBucketAclV2 = new Aws.S3.BucketAclV2("example", new()
 *     {
 *         Bucket = exampleBucketV2.Id,
 *         Acl = "private",
 *     });
 *     var exampleLoggingConfiguration = new Aws.IvsChat.LoggingConfiguration("example", new()
 *     {
 *         DestinationConfiguration = new Aws.IvsChat.Inputs.LoggingConfigurationDestinationConfigurationArgs
 *         {
 *             Firehose = new Aws.IvsChat.Inputs.LoggingConfigurationDestinationConfigurationFirehoseArgs
 *             {
 *                 DeliveryStreamName = example.Name,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ivschat"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kinesis"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleBucketV2, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			BucketPrefix: pulumi.String("tf-ivschat-logging-bucket"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"firehose.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleRole, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			Name:             pulumi.String("firehose_example_role"),
 * 			AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := kinesis.NewFirehoseDeliveryStream(ctx, "example", &kinesis.FirehoseDeliveryStreamArgs{
 * 			Name:        pulumi.String("pulumi-kinesis-firehose-extended-s3-example-stream"),
 * 			Destination: pulumi.String("extended_s3"),
 * 			ExtendedS3Configuration: &kinesis.FirehoseDeliveryStreamExtendedS3ConfigurationArgs{
 * 				RoleArn:   exampleRole.Arn,
 * 				BucketArn: exampleBucketV2.Arn,
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"LogDeliveryEnabled": pulumi.String("true"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketAclV2(ctx, "example", &s3.BucketAclV2Args{
 * 			Bucket: exampleBucketV2.ID(),
 * 			Acl:    pulumi.String("private"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ivschat.NewLoggingConfiguration(ctx, "example", &ivschat.LoggingConfigurationArgs{
 * 			DestinationConfiguration: &ivschat.LoggingConfigurationDestinationConfigurationArgs{
 * 				Firehose: &ivschat.LoggingConfigurationDestinationConfigurationFirehoseArgs{
 * 					DeliveryStreamName: example.Name,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.ivschat.LoggingConfiguration;
 * import com.pulumi.aws.ivschat.LoggingConfigurationArgs;
 * import com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationArgs;
 * import com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationFirehoseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .bucketPrefix("tf-ivschat-logging-bucket")
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("firehose.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .name("firehose_example_role")
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var example = new FirehoseDeliveryStream("example", FirehoseDeliveryStreamArgs.builder()
 *             .name("pulumi-kinesis-firehose-extended-s3-example-stream")
 *             .destination("extended_s3")
 *             .extendedS3Configuration(FirehoseDeliveryStreamExtendedS3ConfigurationArgs.builder()
 *                 .roleArn(exampleRole.arn())
 *                 .bucketArn(exampleBucketV2.arn())
 *                 .build())
 *             .tags(Map.of("LogDeliveryEnabled", "true"))
 *             .build());
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .acl("private")
 *             .build());
 *         var exampleLoggingConfiguration = new LoggingConfiguration("exampleLoggingConfiguration", LoggingConfigurationArgs.builder()
 *             .destinationConfiguration(LoggingConfigurationDestinationConfigurationArgs.builder()
 *                 .firehose(LoggingConfigurationDestinationConfigurationFirehoseArgs.builder()
 *                     .deliveryStreamName(example.name())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kinesis:FirehoseDeliveryStream
 *     properties:
 *       name: pulumi-kinesis-firehose-extended-s3-example-stream
 *       destination: extended_s3
 *       extendedS3Configuration:
 *         roleArn: ${exampleRole.arn}
 *         bucketArn: ${exampleBucketV2.arn}
 *       tags:
 *         LogDeliveryEnabled: 'true'
 *   exampleBucketV2:
 *     type: aws:s3:BucketV2
 *     name: example
 *     properties:
 *       bucketPrefix: tf-ivschat-logging-bucket
 *   exampleBucketAclV2:
 *     type: aws:s3:BucketAclV2
 *     name: example
 *     properties:
 *       bucket: ${exampleBucketV2.id}
 *       acl: private
 *   exampleRole:
 *     type: aws:iam:Role
 *     name: example
 *     properties:
 *       name: firehose_example_role
 *       assumeRolePolicy: ${assumeRole.json}
 *   exampleLoggingConfiguration:
 *     type: aws:ivschat:LoggingConfiguration
 *     name: example
 *     properties:
 *       destinationConfiguration:
 *         firehose:
 *           deliveryStreamName: ${example.name}
 * variables:
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - firehose.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic Usage - Logging to S3
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucketName: tf-ivschat-logging
 *       forceDestroy: true
 *   exampleLoggingConfiguration:
 *     type: aws:ivschat:LoggingConfiguration
 *     name: example
 *     properties:
 *       destinationConfiguration:
 *         s3:
 *           bucketName: ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IVS (Interactive Video) Chat Logging Configuration using the ARN. For example:
 * ```sh
 * $ pulumi import aws:ivschat/loggingConfiguration:LoggingConfiguration example arn:aws:ivschat:us-west-2:326937407773:logging-configuration/MMUQc8wcqZmC
 * ```
 * @property destinationConfiguration Object containing destination configuration for where chat activity will be logged. This object must contain exactly one of the following children arguments:
 * @property name Logging Configuration name.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class LoggingConfigurationArgs(
    public val destinationConfiguration: Output<LoggingConfigurationDestinationConfigurationArgs>? =
        null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ivschat.LoggingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ivschat.LoggingConfigurationArgs =
        com.pulumi.aws.ivschat.LoggingConfigurationArgs.builder()
            .destinationConfiguration(
                destinationConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LoggingConfigurationArgs].
 */
@PulumiTagMarker
public class LoggingConfigurationArgsBuilder internal constructor() {
    private var destinationConfiguration: Output<LoggingConfigurationDestinationConfigurationArgs>? =
        null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Object containing destination configuration for where chat activity will be logged. This object must contain exactly one of the following children arguments:
     */
    @JvmName("gprduaijxwscouxg")
    public suspend fun destinationConfiguration(`value`: Output<LoggingConfigurationDestinationConfigurationArgs>) {
        this.destinationConfiguration = value
    }

    /**
     * @param value Logging Configuration name.
     */
    @JvmName("cneehjbclyjpwtgt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pgfdyrptgguafxvn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Object containing destination configuration for where chat activity will be logged. This object must contain exactly one of the following children arguments:
     */
    @JvmName("vbtixdqspcfkwpgl")
    public suspend fun destinationConfiguration(`value`: LoggingConfigurationDestinationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationConfiguration = mapped
    }

    /**
     * @param argument Object containing destination configuration for where chat activity will be logged. This object must contain exactly one of the following children arguments:
     */
    @JvmName("fudageigpnclkdgh")
    public suspend fun destinationConfiguration(argument: suspend LoggingConfigurationDestinationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = LoggingConfigurationDestinationConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.destinationConfiguration = mapped
    }

    /**
     * @param value Logging Configuration name.
     */
    @JvmName("sooutvdfgdoehtsh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qapllfovafgmkusi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ljctccjmgijhwdps")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LoggingConfigurationArgs = LoggingConfigurationArgs(
        destinationConfiguration = destinationConfiguration,
        name = name,
        tags = tags,
    )
}
