@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivschat.kotlin

import com.pulumi.aws.ivschat.RoomArgs.builder
import com.pulumi.aws.ivschat.kotlin.inputs.RoomMessageReviewHandlerArgs
import com.pulumi.aws.ivschat.kotlin.inputs.RoomMessageReviewHandlerArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS IVS (Interactive Video) Chat Room.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ivschat.Room("example", {name: "tf-room"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ivschat.Room("example", name="tf-room")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.IvsChat.Room("example", new()
 *     {
 *         Name = "tf-room",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ivschat"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ivschat.NewRoom(ctx, "example", &ivschat.RoomArgs{
 * 			Name: pulumi.String("tf-room"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ivschat.Room;
 * import com.pulumi.aws.ivschat.RoomArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Room("example", RoomArgs.builder()
 *             .name("tf-room")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ivschat:Room
 *     properties:
 *       name: tf-room
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IVS (Interactive Video) Chat Room using the ARN. For example:
 * ```sh
 * $ pulumi import aws:ivschat/room:Room example arn:aws:ivschat:us-west-2:326937407773:room/GoXEXyB4VwHb
 * ```
 * @property loggingConfigurationIdentifiers List of Logging Configuration
 * ARNs to attach to the room.
 * @property maximumMessageLength Maximum number of characters in a single
 * message. Messages are expected to be UTF-8 encoded and this limit applies
 * specifically to rune/code-point count, not number of bytes.
 * @property maximumMessageRatePerSecond Maximum number of messages per
 * second that can be sent to the room (by all clients).
 * @property messageReviewHandler Configuration information for optional
 * review of messages.
 * @property name Room name.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class RoomArgs(
    public val loggingConfigurationIdentifiers: Output<List<String>>? = null,
    public val maximumMessageLength: Output<Int>? = null,
    public val maximumMessageRatePerSecond: Output<Int>? = null,
    public val messageReviewHandler: Output<RoomMessageReviewHandlerArgs>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ivschat.RoomArgs> {
    override fun toJava(): com.pulumi.aws.ivschat.RoomArgs = com.pulumi.aws.ivschat.RoomArgs.builder()
        .loggingConfigurationIdentifiers(
            loggingConfigurationIdentifiers?.applyValue({ args0 ->
                args0.map({ args0 -> args0 })
            }),
        )
        .maximumMessageLength(maximumMessageLength?.applyValue({ args0 -> args0 }))
        .maximumMessageRatePerSecond(maximumMessageRatePerSecond?.applyValue({ args0 -> args0 }))
        .messageReviewHandler(
            messageReviewHandler?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .name(name?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [RoomArgs].
 */
@PulumiTagMarker
public class RoomArgsBuilder internal constructor() {
    private var loggingConfigurationIdentifiers: Output<List<String>>? = null

    private var maximumMessageLength: Output<Int>? = null

    private var maximumMessageRatePerSecond: Output<Int>? = null

    private var messageReviewHandler: Output<RoomMessageReviewHandlerArgs>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value List of Logging Configuration
     * ARNs to attach to the room.
     */
    @JvmName("hvlaflxndovbnaia")
    public suspend fun loggingConfigurationIdentifiers(`value`: Output<List<String>>) {
        this.loggingConfigurationIdentifiers = value
    }

    @JvmName("mnndiyufosveuofb")
    public suspend fun loggingConfigurationIdentifiers(vararg values: Output<String>) {
        this.loggingConfigurationIdentifiers = Output.all(values.asList())
    }

    /**
     * @param values List of Logging Configuration
     * ARNs to attach to the room.
     */
    @JvmName("uxrkogyqicbpxvod")
    public suspend fun loggingConfigurationIdentifiers(values: List<Output<String>>) {
        this.loggingConfigurationIdentifiers = Output.all(values)
    }

    /**
     * @param value Maximum number of characters in a single
     * message. Messages are expected to be UTF-8 encoded and this limit applies
     * specifically to rune/code-point count, not number of bytes.
     */
    @JvmName("nweuykcxjmwkdmvx")
    public suspend fun maximumMessageLength(`value`: Output<Int>) {
        this.maximumMessageLength = value
    }

    /**
     * @param value Maximum number of messages per
     * second that can be sent to the room (by all clients).
     */
    @JvmName("iuwypdbmpnhlqyre")
    public suspend fun maximumMessageRatePerSecond(`value`: Output<Int>) {
        this.maximumMessageRatePerSecond = value
    }

    /**
     * @param value Configuration information for optional
     * review of messages.
     */
    @JvmName("xkdmvtyoctukhrco")
    public suspend fun messageReviewHandler(`value`: Output<RoomMessageReviewHandlerArgs>) {
        this.messageReviewHandler = value
    }

    /**
     * @param value Room name.
     */
    @JvmName("hyrwyhhglbudiagp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pgbobyduvspelgme")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value List of Logging Configuration
     * ARNs to attach to the room.
     */
    @JvmName("kvxraqkrvfkohapk")
    public suspend fun loggingConfigurationIdentifiers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingConfigurationIdentifiers = mapped
    }

    /**
     * @param values List of Logging Configuration
     * ARNs to attach to the room.
     */
    @JvmName("tvssgxmxqsjmgisq")
    public suspend fun loggingConfigurationIdentifiers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loggingConfigurationIdentifiers = mapped
    }

    /**
     * @param value Maximum number of characters in a single
     * message. Messages are expected to be UTF-8 encoded and this limit applies
     * specifically to rune/code-point count, not number of bytes.
     */
    @JvmName("krhgyhjsvkwyllec")
    public suspend fun maximumMessageLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumMessageLength = mapped
    }

    /**
     * @param value Maximum number of messages per
     * second that can be sent to the room (by all clients).
     */
    @JvmName("uaxxvgmsmcfeqtcd")
    public suspend fun maximumMessageRatePerSecond(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumMessageRatePerSecond = mapped
    }

    /**
     * @param value Configuration information for optional
     * review of messages.
     */
    @JvmName("siwawifardciktta")
    public suspend fun messageReviewHandler(`value`: RoomMessageReviewHandlerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageReviewHandler = mapped
    }

    /**
     * @param argument Configuration information for optional
     * review of messages.
     */
    @JvmName("gmpphtnuwmxvuiwd")
    public suspend fun messageReviewHandler(argument: suspend RoomMessageReviewHandlerArgsBuilder.() -> Unit) {
        val toBeMapped = RoomMessageReviewHandlerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.messageReviewHandler = mapped
    }

    /**
     * @param value Room name.
     */
    @JvmName("cncupqwfaeigdrbr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("btqceoovrmljgmhm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("whqolabfunkebkhd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RoomArgs = RoomArgs(
        loggingConfigurationIdentifiers = loggingConfigurationIdentifiers,
        maximumMessageLength = maximumMessageLength,
        maximumMessageRatePerSecond = maximumMessageRatePerSecond,
        messageReviewHandler = messageReviewHandler,
        name = name,
        tags = tags,
    )
}
