@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ivschat.kotlin.inputs

import com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchLogs An Amazon CloudWatch Logs destination configuration where chat activity will be logged.
 * @property firehose An Amazon Kinesis Data Firehose destination configuration where chat activity will be logged.
 * @property s3 An Amazon S3 destination configuration where chat activity will be logged.
 */
public data class LoggingConfigurationDestinationConfigurationArgs(
    public val cloudwatchLogs: Output<LoggingConfigurationDestinationConfigurationCloudwatchLogsArgs>? =
        null,
    public val firehose: Output<LoggingConfigurationDestinationConfigurationFirehoseArgs>? = null,
    public val s3: Output<LoggingConfigurationDestinationConfigurationS3Args>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationArgs =
        com.pulumi.aws.ivschat.inputs.LoggingConfigurationDestinationConfigurationArgs.builder()
            .cloudwatchLogs(cloudwatchLogs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .firehose(firehose?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3(s3?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [LoggingConfigurationDestinationConfigurationArgs].
 */
@PulumiTagMarker
public class LoggingConfigurationDestinationConfigurationArgsBuilder internal constructor() {
    private var cloudwatchLogs:
        Output<LoggingConfigurationDestinationConfigurationCloudwatchLogsArgs>? = null

    private var firehose: Output<LoggingConfigurationDestinationConfigurationFirehoseArgs>? = null

    private var s3: Output<LoggingConfigurationDestinationConfigurationS3Args>? = null

    /**
     * @param value An Amazon CloudWatch Logs destination configuration where chat activity will be logged.
     */
    @JvmName("nhyswqrcaisyokjb")
    public suspend fun cloudwatchLogs(`value`: Output<LoggingConfigurationDestinationConfigurationCloudwatchLogsArgs>) {
        this.cloudwatchLogs = value
    }

    /**
     * @param value An Amazon Kinesis Data Firehose destination configuration where chat activity will be logged.
     */
    @JvmName("dfnevylswoklswsh")
    public suspend fun firehose(`value`: Output<LoggingConfigurationDestinationConfigurationFirehoseArgs>) {
        this.firehose = value
    }

    /**
     * @param value An Amazon S3 destination configuration where chat activity will be logged.
     */
    @JvmName("yrrvhcupfgvpymda")
    public suspend fun s3(`value`: Output<LoggingConfigurationDestinationConfigurationS3Args>) {
        this.s3 = value
    }

    /**
     * @param value An Amazon CloudWatch Logs destination configuration where chat activity will be logged.
     */
    @JvmName("uumuneuykmaflsuf")
    public suspend fun cloudwatchLogs(`value`: LoggingConfigurationDestinationConfigurationCloudwatchLogsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLogs = mapped
    }

    /**
     * @param argument An Amazon CloudWatch Logs destination configuration where chat activity will be logged.
     */
    @JvmName("jepdctwoaticabjw")
    public suspend fun cloudwatchLogs(argument: suspend LoggingConfigurationDestinationConfigurationCloudwatchLogsArgsBuilder.() -> Unit) {
        val toBeMapped =
            LoggingConfigurationDestinationConfigurationCloudwatchLogsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLogs = mapped
    }

    /**
     * @param value An Amazon Kinesis Data Firehose destination configuration where chat activity will be logged.
     */
    @JvmName("nlalfgbugfchbpnx")
    public suspend fun firehose(`value`: LoggingConfigurationDestinationConfigurationFirehoseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firehose = mapped
    }

    /**
     * @param argument An Amazon Kinesis Data Firehose destination configuration where chat activity will be logged.
     */
    @JvmName("hplskxbqeckdixiq")
    public suspend fun firehose(argument: suspend LoggingConfigurationDestinationConfigurationFirehoseArgsBuilder.() -> Unit) {
        val toBeMapped = LoggingConfigurationDestinationConfigurationFirehoseArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.firehose = mapped
    }

    /**
     * @param value An Amazon S3 destination configuration where chat activity will be logged.
     */
    @JvmName("kdxtdgrphuciruja")
    public suspend fun s3(`value`: LoggingConfigurationDestinationConfigurationS3Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3 = mapped
    }

    /**
     * @param argument An Amazon S3 destination configuration where chat activity will be logged.
     */
    @JvmName("rwgkykgcihgmgegl")
    public suspend fun s3(argument: suspend LoggingConfigurationDestinationConfigurationS3ArgsBuilder.() -> Unit) {
        val toBeMapped = LoggingConfigurationDestinationConfigurationS3ArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3 = mapped
    }

    internal fun build(): LoggingConfigurationDestinationConfigurationArgs =
        LoggingConfigurationDestinationConfigurationArgs(
            cloudwatchLogs = cloudwatchLogs,
            firehose = firehose,
            s3 = s3,
        )
}
